/*  LibKiazma 0.2
 *  Copyright (C) 2006/2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef KIAZMA_METADATA_CHOOSER_H
#define KIAZMA_METADATA_CHOOSER_H

#include "libkiazma.h"

#define KIAZMA_METADATA_CHOOSER_TYPE			( kiazma_metadata_chooser_get_type () )
#define KIAZMA_METADATA_CHOOSER(obj)			( G_TYPE_CHECK_INSTANCE_CAST ( ( obj ), KIAZMA_METADATA_CHOOSER_TYPE, KiazmaMetadataChooser ) )
#define KIAZMA_METADATA_CHOOSER_CLASS(klass)		( G_TYPE_CHECK_CLASS_CAST ( ( klass ), KIAZMA_METADATA_CHOOSER_TYPE, KiazmaMetadataChooserClass ) )
#define IS_KIAZMA_METADATA_CHOOSER(obj)			( G_TYPE_CHECK_INSTANCE_TYPE ( ( obj ), KIAZMA_METADATA_CHOOSER_TYPE ) )
#define IS_KIAZMA_METADATA_CHOOSER_CLASS(klass)		( G_TYPE_CHECK_CLASS_TYPE ( ( klass ), KIAZMA_METADATA_CHOOSER_TYPE ) )

typedef struct _KiazmaMetadataChooser			KiazmaMetadataChooser;
typedef struct _KiazmaMetadataChooserClass		KiazmaMetadataChooserClass;

struct _KiazmaMetadataChooser {
	GtkHBox			main_win;
	GtkWidget		*meta;
	GtkWidget		*value;
};

struct _KiazmaMetadataChooserClass {
	GtkHBoxClass		parent_class;
	void ( *kiazma_metadata_chooser )	( KiazmaMetadataChooser *synp );
};

GType		kiazma_metadata_chooser_get_type			() G_GNUC_CONST;
GtkWidget*	kiazma_metadata_chooser_new				();
void		kiazma_metadata_chooser_add_meta			( KiazmaMetadataChooser *chooser, UINT64 meta );
void		kiazma_metadata_chooser_fill_with_complete_range	( KiazmaMetadataChooser *chooser );
void		kiazma_metadata_chooser_remove_meta			( KiazmaMetadataChooser *chooser, UINT64 meta );
void		kiazma_metadata_chooser_set				( KiazmaMetadataChooser *chooser, UINT64 meta, gchar *value );
gboolean	kiazma_metadata_chooser_get				( KiazmaMetadataChooser *chooser, UINT64 *meta, gchar **value );
void		kiazma_metadata_chooser_reset				( KiazmaMetadataChooser *chooser );

#endif /* KIAZMA_METADATA_CHOOSER_H */
