/*  LibKiazma 0.2
 *  Copyright (C) 2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef KIAZMA_METADATA_COLLECTOR_H
#define KIAZMA_METADATA_COLLECTOR_H

#include "libkiazma.h"

#define KIAZMA_METADATA_COLLECTOR_TYPE			( kiazma_metadata_collector_get_type () )
#define KIAZMA_METADATA_COLLECTOR(obj)			( G_TYPE_CHECK_INSTANCE_CAST ( ( obj ), KIAZMA_METADATA_COLLECTOR_TYPE, KiazmaMetadataCollector ) )
#define KIAZMA_METADATA_COLLECTOR_CLASS(klass)		( G_TYPE_CHECK_CLASS_CAST ( ( klass ), KIAZMA_METADATA_COLLECTOR_TYPE, KiazmaMetadataCollectorClass ) )
#define IS_KIAZMA_METADATA_COLLECTOR(obj)		( G_TYPE_CHECK_INSTANCE_TYPE ( ( obj ), KIAZMA_METADATA_COLLECTOR_TYPE ) )
#define IS_KIAZMA_METADATA_COLLECTOR_CLASS(klass)	( G_TYPE_CHECK_CLASS_TYPE ( ( klass ), KIAZMA_METADATA_COLLECTOR_TYPE ) )

typedef struct _KiazmaMetadataCollector			KiazmaMetadataCollector;
typedef struct _KiazmaMetadataCollectorClass		KiazmaMetadataCollectorClass;

struct _KiazmaMetadataCollector {
	GtkHBox			main_win;
	GtkTreeStore		*list_model;
	GtkWidget		*list;
	GtkTreeSelection	*list_selector;
	GtkTreeIter		current;
	GtkWidget		*add_button;
	GtkWidget		*remove_button;
	GtkWidget		*edit_button;
};

struct _KiazmaMetadataCollectorClass {
	GtkHBoxClass		parent_class;
	void ( *kiazma_metadata_collector )	( KiazmaMetadataCollector *synp );
};

GType		kiazma_metadata_collector_get_type			() G_GNUC_CONST;
GtkWidget*	kiazma_metadata_collector_new				();
void		kiazma_metadata_collector_reset				( KiazmaMetadataCollector *item );
void		kiazma_metadata_collector_add_item			( KiazmaMetadataCollector *item, UINT64 meta, gchar *value );
gboolean	kiazma_metadata_collector_get_first			( KiazmaMetadataCollector *item, UINT64 *meta, gchar **value );
gboolean	kiazma_metadata_collector_get_next			( KiazmaMetadataCollector *item, UINT64 *meta, gchar **value );

#endif /* KIAZMA_METADATA_COLLECTOR_H */
