/*  LibKiazma 0.2
 *  Copyright (C) 2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/**
	@file	kiazma_metadata_selector.c
*/

#include "libkiazma.h"
#include "kiazma_metadata_selector.h"

/**
	@internal

	Init the class for KiazmaMetadataSelector

	@param	klass	Instance of the class to init
*/
static void kiazma_metadata_selector_class_init ( KiazmaMetadataSelectorClass *klass ) {
	return;
}

/**
	@internal

	@param	ttt
*/
static void kiazma_metadata_selector_init ( KiazmaMetadataSelector *ttt ) {
	GtkTreeIter iter;
	GtkListStore *mod;
	GtkCellRenderer *render_text;

	mod = gtk_list_store_new ( 2, G_TYPE_STRING, G_TYPE_UINT64 );
	gtk_tree_sortable_set_sort_column_id ( GTK_TREE_SORTABLE ( mod ), 1, GTK_SORT_ASCENDING );
	gtk_list_store_append ( mod, &iter );
	gtk_list_store_set ( mod, &iter, 0, _( "Choose a metadata" ), -1 );
	gtk_list_store_set ( mod, &iter, 1, 0LL, -1 );

	gtk_combo_box_set_model ( GTK_COMBO_BOX ( ttt ), ( GtkTreeModel* ) mod );
	gtk_combo_box_set_active ( GTK_COMBO_BOX ( ttt ), 0 );

	render_text = gtk_cell_renderer_text_new ();
	gtk_cell_layout_pack_start ( GTK_CELL_LAYOUT ( ttt ), render_text, TRUE );
	gtk_cell_layout_add_attribute ( GTK_CELL_LAYOUT ( ttt ), render_text, "text", 0 );
}

/**
*/
GType kiazma_metadata_selector_get_type () {
	static GType ttt_type = 0;

	if ( !ttt_type ) {
		static const GTypeInfo ttt_info = {
			sizeof ( KiazmaMetadataSelectorClass ),
			NULL,
			NULL,
			( GClassInitFunc ) kiazma_metadata_selector_class_init,
			NULL,
			NULL,
			sizeof ( KiazmaMetadataSelector ),
			0,
			( GInstanceInitFunc ) kiazma_metadata_selector_init,
		};

		ttt_type = g_type_register_static ( GTK_TYPE_COMBO_BOX, "KiazmaMetadataSelector", &ttt_info, 0 );
	}

	return ttt_type;
}

/**
*/
GtkWidget* kiazma_metadata_selector_new () {
	return GTK_WIDGET ( g_object_new ( kiazma_metadata_selector_get_type (), NULL ) );
}

/**
*/
GtkWidget* kiazma_metadata_selector_new_full () {
	UINT64 i;
	GtkWidget *item;

	item = kiazma_metadata_selector_new ();

	for ( i = 0; i < METADATA_END; i++ )
		kiazma_metadata_selector_add_meta ( KIAZMA_METADATA_SELECTOR ( item ), i );

	return item;
}

/**
	@param	item
	@param	meta
*/
void kiazma_metadata_selector_add_meta ( KiazmaMetadataSelector *item, UINT64 meta ) {
	GtkTreeIter iter;
	GtkListStore *mod;

	mod = ( GtkListStore* ) gtk_combo_box_get_model ( GTK_COMBO_BOX ( item ) );
	gtk_list_store_append ( mod, &iter );
	gtk_list_store_set ( mod, &iter, 0, hyppo_metadata_translate_in_string ( meta ), 1, meta, -1 );
}

/**
	@param	chooser
	@param	meta
*/
void kiazma_metadata_selector_remove_meta ( KiazmaMetadataSelector *chooser, UINT64 meta ) {
	UINT64 i_meta;
	GtkTreeIter iter;
	GtkTreeModel *mod;

	mod = gtk_combo_box_get_model ( GTK_COMBO_BOX ( chooser ) );
	gtk_tree_model_get_iter_first ( mod, &iter );

	do {
		gtk_tree_model_get ( mod, &iter, 1, &i_meta, -1 );
		if ( i_meta == meta ) {
			gtk_list_store_remove ( ( GtkListStore* ) mod, &iter );
			break;
		}

	} while ( gtk_tree_model_iter_next ( mod, &iter ) );
}

/**
	@param	item

	@return
*/
UINT64 kiazma_metadata_selector_get ( KiazmaMetadataSelector *item ) {
	UINT64 meta			= METADATA_INVALID;
	GtkTreeIter iter;
	GtkTreeModel *mod;

	mod = gtk_combo_box_get_model ( GTK_COMBO_BOX ( item ) );
	if ( gtk_combo_box_get_active_iter ( GTK_COMBO_BOX ( item ), &iter ) )
		gtk_tree_model_get ( mod, &iter, 1, &meta, -1 );

	return meta;
}

/**
	@param	item
	@param	meta
*/
void kiazma_metadata_selector_set ( KiazmaMetadataSelector *item, UINT64 meta ) {
	UINT64 i_meta;
	GtkTreeIter iter;
	GtkTreeModel *mod;

	mod = gtk_combo_box_get_model ( GTK_COMBO_BOX ( item ) );
	gtk_tree_model_get_iter_first ( mod, &iter );

	do {
		gtk_tree_model_get ( mod, &iter, 1, &i_meta, -1 );
		if ( meta == i_meta ) {
			gtk_combo_box_set_active_iter ( GTK_COMBO_BOX ( item ), &iter );
			break;
		}
	} while ( gtk_tree_model_iter_next ( mod, &iter ) );
}
