/*  LibKiazma 0.2
 *  Copyright (C) 2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef KIAZMA_METADATA_SET_CHOOSER_H
#define KIAZMA_METADATA_SET_CHOOSER_H

#include "libkiazma.h"

#define KIAZMA_METADATA_SET_CHOOSER_TYPE			( kiazma_metadata_set_chooser_get_type () )
#define KIAZMA_METADATA_SET_CHOOSER(obj)			( G_TYPE_CHECK_INSTANCE_CAST ( ( obj ), KIAZMA_METADATA_SET_CHOOSER_TYPE, KiazmaMetadataSetChooser ) )
#define KIAZMA_METADATA_SET_CHOOSER_CLASS(klass)		( G_TYPE_CHECK_CLASS_CAST ( ( klass ), KIAZMA_METADATA_SET_CHOOSER_TYPE, KiazmaMetadataSetChooserClass ) )
#define IS_KIAZMA_METADATA_SET_CHOOSER(obj)			( G_TYPE_CHECK_INSTANCE_TYPE ( ( obj ), KIAZMA_METADATA_SET_CHOOSER_TYPE ) )
#define IS_KIAZMA_METADATA_SET_CHOOSER_CLASS(klass)		( G_TYPE_CHECK_CLASS_TYPE ( ( klass ), KIAZMA_METADATA_SET_CHOOSER_TYPE ) )

typedef struct _KiazmaMetadataSetChooser			KiazmaMetadataSetChooser;
typedef struct _KiazmaMetadataSetChooserClass			KiazmaMetadataSetChooserClass;

struct _KiazmaMetadataSetChooser {
	GtkHBox			main_win;
	GtkWidget		*meta;
	GtkWidget		*set_type;
	GtkWidget		*value;
};

struct _KiazmaMetadataSetChooserClass {
	GtkHBoxClass				parent_class;
	void ( *kiazma_query_editor )		( KiazmaMetadataSetChooser *synp );
};

GType		kiazma_metadata_set_chooser_get_type			() G_GNUC_CONST;
GtkWidget*	kiazma_metadata_set_chooser_new				();
GtkWidget*	kiazma_metadata_set_chooser_new_full			();
void		kiazma_metadata_set_chooser_add_meta			( KiazmaMetadataSetChooser *chooser, UINT64 meta );
void		kiazma_metadata_set_chooser_remove_meta			( KiazmaMetadataSetChooser *chooser, UINT64 meta );
void		kiazma_metadata_set_chooser_set				( KiazmaMetadataSetChooser *chooser, UINT64 meta, HYPPO_COMPARISON_OPERATOR op, gchar *value );
gboolean	kiazma_metadata_set_chooser_get				( KiazmaMetadataSetChooser *chooser, UINT64 *meta, HYPPO_COMPARISON_OPERATOR *op, gchar **value );
gchar*		kiazma_metadata_set_chooser_to_string			( KiazmaMetadataSetChooser *chooser );
GtkWidget*	kiazma_metadata_set_chooser_copy			( KiazmaMetadataSetChooser *item );
void		kiazma_metadata_set_chooser_reset			( KiazmaMetadataSetChooser *item );

#endif /* KIAZMA_METADATA_SET_CHOOSER_H */
