/*  LibKiazma 0.2
 *  Copyright (C) 2006/2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef KIAZMA_METADATA_WRAPPER_H
#define KIAZMA_METADATA_WRAPPER_H

#include "libkiazma.h"

#define KIAZMA_METADATA_WRAPPER_TYPE			( kiazma_metadata_wrapper_get_type () )
#define KIAZMA_METADATA_WRAPPER(obj)			( G_TYPE_CHECK_INSTANCE_CAST ( ( obj ), KIAZMA_METADATA_WRAPPER_TYPE, KiazmaMetadataWrapper ) )
#define KIAZMA_METADATA_WRAPPER_CLASS(klass)		( G_TYPE_CHECK_CLASS_CAST ( ( klass ), KIAZMA_METADATA_WRAPPER_TYPE, KiazmaMetadataWrapperClass ) )
#define IS_KIAZMA_METADATA_WRAPPER(obj)			( G_TYPE_CHECK_INSTANCE_TYPE ( ( obj ), KIAZMA_METADATA_WRAPPER_TYPE ) )
#define IS_KIAZMA_METADATA_WRAPPER_CLASS(klass)		( G_TYPE_CHECK_CLASS_TYPE ( ( klass ), KIAZMA_METADATA_WRAPPER_TYPE ) )

typedef struct _KiazmaMetadataWrapper			KiazmaMetadataWrapper;
typedef struct _KiazmaMetadataWrapperClass		KiazmaMetadataWrapperClass;

struct _KiazmaMetadataWrapper {
	GtkFrame		main_win;
	UINT64			metadata;
};

struct _KiazmaMetadataWrapperClass {
	GtkFrameClass				parent_class;
	void ( *kiazma_metadata_wrapper )	( KiazmaMetadataWrapper *synp );
};

GType		kiazma_metadata_wrapper_get_type		() G_GNUC_CONST;
GtkWidget*	kiazma_metadata_wrapper_new			( UINT64 meta );
UINT64		kiazma_metadata_wrapper_get_meta		( KiazmaMetadataWrapper *wrap );
void		kiazma_metadata_wrapper_set_value		( KiazmaMetadataWrapper *wrap, gchar *value );
gchar*		kiazma_metadata_wrapper_get_value		( KiazmaMetadataWrapper *wrap );

#endif /* KIAZMA_METADATA_WRAPPER_H */
