/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/*
 * Copyright © 2000 Eazel, Inc.
 * Copyright © 2004, 2006 Christian Persch
 *
 * Nautilus is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Nautilus is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * Author: Andy Hertzfeld <andy@eazel.com>
 *
 * $Id$
 */

/*  LibKiazma 0.2
 *  Copyright (C) 2006/2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 */

#ifndef KIAZMA_SPINNER_H
#define KIAZMA_SPINNER_H

#include "libkiazma.h"

G_BEGIN_DECLS

#define KIAZMA_TYPE_SPINNER		(kiazma_spinner_get_type ())
#define KIAZMA_SPINNER(o)		(G_TYPE_CHECK_INSTANCE_CAST ((o), KIAZMA_TYPE_SPINNER, KiazmaSpinner))
#define KIAZMA_SPINNER_CLASS(k)		(G_TYPE_CHECK_CLASS_CAST((k), KIAZMA_TYPE_SPINNER, KiazmaSpinnerClass))
#define KIAZMA_IS_SPINNER(o)		(G_TYPE_CHECK_INSTANCE_TYPE ((o), KIAZMA_TYPE_SPINNER))
#define KIAZMA_IS_SPINNER_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE ((k), KIAZMA_TYPE_SPINNER))
#define KIAZMA_SPINNER_GET_CLASS(o)	(G_TYPE_INSTANCE_GET_CLASS ((o), KIAZMA_TYPE_SPINNER, KiazmaSpinnerClass))

typedef struct _KiazmaSpinner		KiazmaSpinner;
typedef struct _KiazmaSpinnerClass	KiazmaSpinnerClass;
typedef struct _KiazmaSpinnerDetails	KiazmaSpinnerDetails;

struct _KiazmaSpinner
{
	GtkWidget parent;

	/*< private >*/
	KiazmaSpinnerDetails *details;
};

struct _KiazmaSpinnerClass
{
	GtkWidgetClass parent_class;
};

GType		kiazma_spinner_get_type	(void);

GtkWidget      *kiazma_spinner_new	(void);

void		kiazma_spinner_start	(KiazmaSpinner *throbber);

void		kiazma_spinner_stop	(KiazmaSpinner *throbber);

void		kiazma_spinner_set_size	(KiazmaSpinner *spinner,
					 GtkIconSize size);

G_END_DECLS

#endif /* KIAZMA_SPINNER_H */
