/*  LibKiazma 0.2
 *  Copyright (C) 2006/2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef KIAZMA_UIDLIST_H
#define KIAZMA_UIDLIST_H

#include "libkiazma.h"

#define KIAZMA_UIDLIST_TYPE			( kiazma_uidlist_get_type () )
#define KIAZMA_UIDLIST(obj)			( G_TYPE_CHECK_INSTANCE_CAST ( ( obj ), KIAZMA_UIDLIST_TYPE, KiazmaUidList ) )
#define KIAZMA_UIDLIST_CLASS(klass)		( G_TYPE_CHECK_CLASS_CAST ( ( klass ), KIAZMA_UIDLIST_TYPE, KiazmaUidListClass ) )
#define IS_KIAZMA_UIDLIST(obj)			( G_TYPE_CHECK_INSTANCE_TYPE ( ( obj ), KIAZMA_UIDLIST_TYPE ) )
#define IS_KIAZMA_UIDLIST_CLASS(klass)		( G_TYPE_CHECK_CLASS_TYPE ( ( klass ), KIAZMA_UIDLIST_TYPE ) )

typedef struct _KiazmaUidList			KiazmaUidList;
typedef struct _KiazmaUidListClass		KiazmaUidListClass;

struct _KiazmaUidList {
	GtkComboBox		list;
};

struct _KiazmaUidListClass {
	GtkComboBoxClass	parent_class;
	void ( *kiazma_uid_list ) ( KiazmaUidList *synp );
};

GType		kiazma_uidlist_get_type			() G_GNUC_CONST;
GtkWidget*	kiazma_uidlist_new			();
void		kiazma_uidlist_clear			( KiazmaUidList *list );
uid_t		kiazma_uidlist_get_value		( KiazmaUidList *list );
void		kiazma_uidlist_set_value		( KiazmaUidList *list, uid_t user );

#endif /* KIAZMA_UIDLIST_H */
