/*  LibKiazma 0.2
 *  Copyright (C) 2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/**
	@file	kiazma_widget.c
*/

#include "libkiazma.h"
#include "kiazma_widget.h"

/**
	@internal

	Init the class for KiazmaWidget

	@param	klass	Instance of the class to init
*/
static void kiazma_widget_class_init ( KiazmaWidgetClass *klass ) {
	return;
}

/**
	@internal

	Init the internals of KiazmaWidget

	@param	ttt	The KiazmaWidget to init
*/
static void kiazma_widget_init ( KiazmaWidget *ttt ) {
	ttt->file = 0ULL;
	return;
}

/**
	Register the GType for KiazmaWidget

	@return		The newly registered type for the widget
*/
GType kiazma_widget_get_type () {
	static GType ttt_type = 0;

	if ( !ttt_type ) {
		static const GTypeInfo ttt_info = {
			sizeof ( KiazmaWidgetClass ),
			NULL,
			NULL,
			( GClassInitFunc ) kiazma_widget_class_init,
			NULL,
			NULL,
			sizeof ( KiazmaWidget ),
			0,
			( GInstanceInitFunc ) kiazma_widget_init,
		};

		ttt_type = g_type_register_static ( GTK_TYPE_WIDGET, "KiazmaWidget", &ttt_info, 0 );
	}

	return ttt_type;
}

/**
	Builds a new KiazmaWidget

	@return		The new KiazmaWidget
*/
GtkWidget* kiazma_widget_new ( UINT64 file ) {
	GtkWidget *new_item;
	new_item = GTK_WIDGET ( g_object_new ( kiazma_widget_get_type (), NULL ) );
	KIAZMA_WIDGET ( new_item )->file = file;
	return new_item;
}
