/*  Synapse 0.2
 *  Copyright (C) 2006/2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "synapse.h"

/*** SynapseFilePanel ***/

static void synapse_file_panel_class_init ( SynapseFilePanelClass *klass ) {
	return;
}

static gboolean exit_file_panel ( GtkButton *button, SynapseFilePanel *panel ) {
	/**
		@todo	Free structs allocated into the composed widget
	*/
	gtk_dialog_response ( GTK_DIALOG ( panel ), GTK_RESPONSE_OK );
	return FALSE;
}

void synapse_file_panel_init ( SynapseFilePanel *ttt ) {
	GtkWidget *response;

	gtk_widget_set_size_request ( GTK_WIDGET ( ttt ), 500, 600 );
	gtk_window_set_title ( GTK_WINDOW ( ttt ), _( "File Properties" ) );
	gtk_dialog_set_has_separator ( GTK_DIALOG ( ttt ), FALSE );
	gtk_container_set_border_width ( GTK_CONTAINER ( GTK_DIALOG ( ttt )->vbox ), 5 );

	response = gtk_button_new_from_stock ( GTK_STOCK_OK );
	g_signal_connect ( G_OBJECT ( response ), "clicked", G_CALLBACK ( exit_file_panel ), ttt );
	gtk_dialog_add_action_widget ( GTK_DIALOG ( ttt ), response, GTK_RESPONSE_OK );
}

static GtkWidget* add_scrollable_page_in_file_panel ( GtkNotebook *notebook, gchar *title ) {
	GtkWidget *page;
	GtkWidget *scroll;

	page = gtk_vbox_new ( FALSE, 10 );
	scroll = gtk_scrolled_window_new ( NULL, NULL );
	gtk_container_set_border_width ( GTK_CONTAINER ( scroll ), 5 );
	gtk_scrolled_window_set_shadow_type ( GTK_SCROLLED_WINDOW ( scroll ), GTK_SHADOW_NONE );
	gtk_scrolled_window_set_policy ( GTK_SCROLLED_WINDOW ( scroll ), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC );
	gtk_scrolled_window_add_with_viewport ( GTK_SCROLLED_WINDOW ( scroll ), page );
	gtk_viewport_set_shadow_type ( GTK_VIEWPORT ( gtk_bin_get_child ( GTK_BIN ( scroll ) ) ), GTK_SHADOW_NONE );
	gtk_notebook_append_page ( notebook, scroll, gtk_label_new ( title ) );
	return page;
}

static GtkWidget* do_add_button ( SynapseFilePanel *panel, GtkWidget *main_box, GCallback add_callback ) {
	GtkWidget *main_button;
	GtkWidget *inside_box;
	GtkWidget *confirm_button;
	GtkWidget *chooser;

	main_button = gtk_expander_new ( _( "Add a metadata here" ) );
	gtk_box_pack_start ( GTK_BOX ( main_box ), main_button, FALSE, FALSE, 0 );

	inside_box = gtk_vbox_new ( FALSE, 2 );
	gtk_container_add ( GTK_CONTAINER ( main_button ), inside_box );

	chooser = kiazma_metadata_chooser_new ();
	gtk_box_pack_start ( GTK_BOX ( inside_box ), chooser, TRUE, TRUE, 0 );

	confirm_button = gtk_button_new_from_stock ( GTK_STOCK_ADD );
	gtk_box_pack_start ( GTK_BOX ( inside_box ), confirm_button, FALSE, FALSE, 0 );
	g_signal_connect ( G_OBJECT ( confirm_button ), "clicked", add_callback, panel );

	return chooser;
}

static gboolean metadata_changed ( KiazmaMetadataWrapper *wid, SynapseFilePanel *panel ) {
	UINT64 meta;
	gchar *value;

	meta = kiazma_metadata_wrapper_get_meta ( wid );
	value = kiazma_metadata_wrapper_get_value ( wid );
	hyppo_vfs_setxattr ( panel->file, meta, value, XATTR_REPLACE );
	g_free ( value );
	return FALSE;
}

static gboolean metadata_removed ( KiazmaButtonedBox *box, SynapseFilePanel *panel ) {
	UINT64 meta;
	GtkWidget *to_remove;

	to_remove = kiazma_buttoned_box_get_item ( box );
	meta = kiazma_metadata_wrapper_get_meta ( KIAZMA_METADATA_WRAPPER ( to_remove ) );
	hyppo_vfs_removexattr ( panel->file, meta );
	gtk_widget_destroy ( GTK_WIDGET ( box ) );
	gtk_widget_show_all ( GTK_WIDGET ( panel ) );
	return FALSE;
}

static GtkWidget* metadata_summary ( SynapseFilePanel *panel, UINT64 meta, gboolean removable ) {
	gchar value [ MAX_VALUE_SIZE ];
	GtkWidget *wid;
	GtkWidget *remove_box;

	if ( hyppo_vfs_getxattr ( panel->file, meta, value, MAX_VALUE_SIZE ) > 0 ) {
		wid = kiazma_metadata_wrapper_new ( meta );
		g_signal_connect ( G_OBJECT ( wid ), "changed", G_CALLBACK ( metadata_changed ), panel );
		kiazma_metadata_wrapper_set_value ( KIAZMA_METADATA_WRAPPER ( wid ), value );

		if ( removable ) {
			remove_box = kiazma_buttoned_box_new ( wid, GTK_STOCK_REMOVE );
			g_signal_connect ( G_OBJECT ( remove_box ), "clicked", G_CALLBACK ( metadata_removed ), panel );
			return remove_box;
		}
		else
			return wid;
	}

	else
		return NULL;
}

static gboolean added_new_other_metadata ( GtkButton *button, SynapseFilePanel *panel ) {
	UINT64 meta;
	gchar *value;
	gchar *meta_name;
	GtkWidget *element;

	if ( kiazma_metadata_chooser_get ( KIAZMA_METADATA_CHOOSER ( panel->other_adder ), &meta, &value ) == FALSE )
		return FALSE;

	hyppo_vfs_setxattr ( panel->file, meta, value, XATTR_CREATE );
	g_free ( value );
	kiazma_metadata_chooser_remove_meta ( KIAZMA_METADATA_CHOOSER ( panel->other_adder ), meta );
	kiazma_metadata_chooser_reset ( KIAZMA_METADATA_CHOOSER ( panel->other_adder ) );

	element = metadata_summary ( panel, meta, TRUE );
	if ( element ) {
		meta_name = hyppo_metadata_translate_in_string ( meta );
		kiazma_frame_add ( KIAZMA_FRAME ( panel->other_meta ), meta_name, element );
	}

	gtk_widget_show_all ( panel->other_meta );
	return FALSE;
}

static void synapse_file_panel_really_init ( SynapseFilePanel *panel, UINT64 fileid ) {
	UINT64 i;
	UINT64 current_meta;
	gchar *meta_name;
	gchar value [ MAX_VALUE_SIZE ];
	GtkWidget *element;
	GtkWidget *page;
	GtkWidget *notebook;
	GList *iter;

	panel->file = fileid;
	panel->attrs = hyppo_vfs_listxattr ( fileid );
	iter = g_list_first ( panel->attrs );

	notebook = gtk_notebook_new ();
	gtk_box_pack_start ( GTK_BOX ( GTK_DIALOG ( panel )->vbox ), notebook, TRUE, TRUE, 10 );

	page = add_scrollable_page_in_file_panel ( GTK_NOTEBOOK ( notebook ), _( "Main Props" ) );

	panel->system_meta = kiazma_frame_new ( _( "System Metadata" ) );
	gtk_box_pack_start ( GTK_BOX ( page ), panel->system_meta, FALSE, FALSE, 0 );
	panel->general_meta = kiazma_frame_new ( _( "General Metadata" ) );
	gtk_box_pack_start ( GTK_BOX ( page ), panel->general_meta, FALSE, FALSE, 0 );

	for ( i = *( ( UINT64* ) iter->data ); i <= FUNDAMENTAL_METADATA_TO_SHOW; i = *( ( UINT64* ) iter->data ) ) {
		if ( AllMetadata [ i ].flags & META_FLAG_SYSTEM ) {
			hyppo_vfs_getxattr ( fileid, i, value, MAX_VALUE_SIZE );
			meta_name = hyppo_metadata_translate_in_string ( i );
			kiazma_frame_add ( KIAZMA_FRAME ( panel->system_meta ), meta_name, gtk_label_new ( value ) );
		}
		else {
			element = metadata_summary ( panel, i, FALSE );
			if ( element ) {
				meta_name = hyppo_metadata_translate_in_string ( AllMetadata [ i ].id );
				kiazma_frame_add ( KIAZMA_FRAME ( panel->general_meta ), meta_name, element );
			}
		}

		iter = g_list_next ( iter );
		if ( !iter )
			break;
	}

	panel->mimetype = -1;
	panel->mime_meta = NULL;
	panel->mime_adder = NULL;

	page = add_scrollable_page_in_file_panel ( GTK_NOTEBOOK ( notebook ), _( "Others" ) );

	panel->other_meta = kiazma_frame_new ( _( "Others Metadata" ) );
	gtk_box_pack_start ( GTK_BOX ( page ), panel->other_meta, FALSE, FALSE, 0 );
	panel->other_adder = do_add_button ( panel, page, G_CALLBACK ( added_new_other_metadata ) );

	if ( iter ) {
		current_meta = *( ( UINT64* ) iter->data );

		for ( i = FUNDAMENTAL_METADATA_TO_SHOW + 1; i < METADATA_END; i++ ) {
			if ( i == current_meta ) {
				element = metadata_summary ( panel, i, TRUE );

				if ( element ) {
					meta_name = hyppo_metadata_translate_in_string ( i );
					kiazma_frame_add ( KIAZMA_FRAME ( panel->other_meta ), meta_name, element );
				}

				iter = g_list_next ( iter );
				if ( iter )
					current_meta = *( ( UINT64* ) iter->data );
				else
					current_meta = 0;
			}

			else {
				if ( !( AllMetadata [ panel->mimetype ].flags & META_FLAG_SYSTEM ) )
					kiazma_metadata_chooser_add_meta ( KIAZMA_METADATA_CHOOSER ( panel->other_adder ), i );
			}
		}
	}

	else {
		for ( i = FUNDAMENTAL_METADATA_TO_SHOW + 1; i < METADATA_END; i++ )
			if ( !( AllMetadata [ i ].flags & META_FLAG_SYSTEM ) )
				kiazma_metadata_chooser_add_meta ( KIAZMA_METADATA_CHOOSER ( panel->other_adder ), i );
	}
}

GType synapse_file_panel_get_type () {
	static GType ttt_type = 0;

	if ( !ttt_type ) {
		static const GTypeInfo ttt_info = {
			sizeof ( SynapseFilePanelClass ),
			NULL,
			NULL,
			( GClassInitFunc ) synapse_file_panel_class_init,
			NULL,
			NULL,
			sizeof ( SynapseFilePanel ),
			0,
			( GInstanceInitFunc ) synapse_file_panel_init,
		};

		ttt_type = g_type_register_static ( GTK_TYPE_DIALOG, "SynapseFilePanel", &ttt_info, 0 );
	}

	return ttt_type;
}

GtkWidget* synapse_file_panel_new ( UINT64 fileid ) {
	GtkWidget *panel;

	panel = GTK_WIDGET ( g_object_new ( synapse_file_panel_get_type (), NULL ) );
	synapse_file_panel_really_init ( SYNAPSE_FILE_PANEL ( panel ), fileid );
	return panel;
}

void synapse_file_panel_destroy ( SynapseFilePanel *panel ) {
	hyppo_vfs_free_xattrs ( panel->attrs );
	gtk_widget_destroy ( GTK_WIDGET ( panel ) );
}
