/**
 * @file nologin.c
 * Reject a login attempt in a friendly manner, and log it
 *
 * Copyright (C) 2006 Free Software Foundation, Inc.
 *
 *  This file is part of GNU Sysutils
 *
 *  GNU Sysutils is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  GNU Sysutils is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <stdio.h>
#include <errno.h>
#include <syslog.h>
#include <unistd.h>

#include "misc.h"
#include "sysutils.h"

#define PRG_NAME "nologin"	/**< Name shown in logfiles */

extern const char *progname;	/**< Used to store the name of the program */

/**
 * The program's main-function
 *
 * @param argc The number of arguments
 * @param argv The arguments
 * @return 0 on success, errno on failure
 */
int main(int argc, char *argv[])
{
	char *username = getlogin();
	char *tty = ttyname(0);

	(void)argc;
	(void)argv;

	errno = 0;

	/* Initialise support for locales, and set the program-name;
	 * ignore any errors
	 */
	init_locales(PRG_NAME);
	errno = 0;

	openlog(progname, LOG_CONS, LOG_AUTHPRIV);
	syslog(LOG_CRIT,
	       _("Attempted login by %s on %s"),
	       username ? username : _("UNKNOWN"),
	       tty ? tty : _("UNKNOWN"));
	closelog();

	fprintf(stderr,
		_("Login to this account is disabled.\n"));

	return EPERM;
}
