-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "meshes"
require "widgets"
require "textures"
require "dynamics"
require "aviation"
require "nature"

resources = {}

function resources.readfile (name)
   print ("  " .. name)

   return io.open (name):read "*a"
end

function resources.dofile (name)
   print ("  " .. name)

   return assert(loadfile(name))()
end

function resources.pipeline (pipeline)
   local cache = {}

   return function (value)
	     if cache[value] then
		return cache[value]
	     else
		local product = value

		for _, process in ipairs(pipeline) do
		   product = process (product)
		end

		cache[value] = product
	     
		return product
	     end
	  end
end

local function nomips (texture)
   texture.levels = {0, 2}
   return texture
end

resources.basemips = resources.pipeline {resources.dofile, nomips, textures.mirrored}
resources.clamped = resources.pipeline {resources.dofile, textures.clamped}
resources.periodic = resources.pipeline {resources.dofile, textures.periodic}
resources.mirrored = resources.pipeline {resources.dofile, textures.mirrored}
resources.static = resources.pipeline {resources.dofile, meshes.static}
resources.polyhedron = resources.pipeline {resources.dofile, bodies.polyhedron}
resources.elevation = resources.pipeline {resources.dofile, nature.elevation}
resources.airplane = resources.pipeline {resources.dofile, aircraft.airplane}
