/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _AIRPLANE_H_
#define _AIRPLANE_H_

#include "body.h"

@interface Airplane: Node {
    double controls[3];
    double area, span, chord;

    double alpha_0, beta_0;
    double force[3], torque[3];
    
    struct {
	double reference;

	int lengths[10];
	double *values[10];
    } derivatives[6];
}

-(void) getDerivative: (int)k;
-(void) setDerivative: (int)k;

@end

#endif
