/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <GL/glu.h>

#include "texture.h"
#include "ambient.h"

#include "static.h"

@implementation Ambient

-(GLfloat *) intensityConstant
{
    return self->intensityConstant;
}

-(GLuint) intensityMap
{
    return [self->intensityMap index];
}

-(GLfloat *) frame
{
    return self->frame;
}

-(Ambient *) init
{
    [super init];

    self->intensityConstant[0] = 0;
    self->intensityConstant[1] = 0;
    self->intensityConstant[2] = 0;
    
    self->intensityMap = nil;

    return self;
}

-(void) get
{
    const char *k;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "intensity")) {
	lua_getmetatable (_L, 1);
	lua_replace (_L, 1);
	lua_gettable (_L, 1);
    } else {
	[super get];
    }
}

-(void) set
{    
    const char *k;
    int i;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "intensity")) {
        if(lua_istable (_L, 3)) {
            for(i = 0 ; i < 3 ; i += 1) {
                lua_rawgeti (_L, 3, i + 1);
                self->intensityConstant[i] = lua_tonumber (_L, -1);
                
                lua_pop (_L, 1);
            }
	    
	    self->intensityMap = nil;
        } else if(lua_isuserdata (_L, 3)) {
            for(i = 0 ; i < 3 ; i += 1) {
                self->intensityConstant[i] = 0;
            }
	    
	    self->intensityMap = *(id *)lua_touserdata (_L, 3);
	}

	lua_getmetatable (_L, 1);
	lua_replace (_L, 1);
	lua_settable (_L, 1);
    } else {
	[super set];
    }
}
-(void) prepare
{
    GLfloat T[16];

    glMatrixMode (GL_MODELVIEW);
    glPushMatrix ();
    glMultMatrixf(self->homogenous);
    glGetFloatv (GL_MODELVIEW_MATRIX, T);

    self->frame[0] = T[0];
    self->frame[1] = T[4];
    self->frame[2] = T[8];
    
    self->frame[3] = T[1];
    self->frame[4] = T[5];
    self->frame[5] = T[9];

    self->frame[6] = T[2];
    self->frame[7] = T[6];
    self->frame[8] = T[10];
		
    glPopMatrix();
    
    [super prepare];
}

@end
