/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <ode/ode.h>
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>

#include "clamp.h"
#include "body.h"

@implementation Clamp

-(Joint *) init
{
    [super init];

    self->joint = dJointCreateFixed (_WORLD, NULL);

    return self;
}

-(void) set
{
    const char *k;

    k = lua_tostring (_L, -2);
    
    [super set];

    if (!xstrcmp(k, "bodies")) {
	[super set];

	/* Fasten the clamp. */
	
	dJointSetFixed ([self joint]);
    }
}

@end
