/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _ELEVATION_H_
#define _ELEVATION_H_

#include <lua.h>
#include <GL/gl.h>
#include <ode/ode.h>

#include "roam.h"
#include "node.h"

@interface Elevation: Node {
@public
    unsigned char **samples;
    unsigned short **bounds;
    GLuint *imagery, detail;
    int *orders;

    dHeightfieldDataID data;
    dGeomID geom;

    struct block *pools[2];
    
    struct diamond *queues[2][QUEUE_SIZE];
    struct triangle *(*roots)[2];
    
    int size[3];
    float resolution[3];
    
    int blocks[2], chunks[2], queued[2];
    int triangles, diamonds, culled, visible;
    int minimum, maximum;

    int target;
}

-(Elevation *) initWith: (int)width
		     by: (int)height
	   tilesOfOrder: (int)order
          andResolution: (float *) scale;

-(void) loadElevationTile: (int) i
	      withSamples: (unsigned char *)chars
	        andBounds: (unsigned short *)shorts
		 ofLength: (int)n;

-(void) loadImageryTile: (int) i
	     withPixels: (unsigned char *)chars
	       ofLength: (int)n;

-(void) loadDetailPixels: (unsigned char *) pixels
	        ofLength: (int) length;

-(void) query;

-(void) freeBuffers;

@end

#endif
