/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <time.h>
#include "lamp.h"

#define N 32

@implementation Lamp

-(Lamp *) init
{
    [super init];
    
    self->intensity = 0;
    
    return self;
}

-(GLfloat) ambience
{
    return self->ambience;
}

-(GLuint) intensity
{
    return self->intensity;
}

-(void) get
{
    const char *k;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "intensity")) {
	lua_getmetatable (_L, 1);
	lua_replace (_L, 1);
	lua_gettable (_L, 1);
    } else if (!xstrcmp(k, "ambience")) {
	lua_pushnumber (_L, self->ambience);
    } else {
	[super get];
    }
}

-(void) set
{    
    const char *k;
    int i;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "intensity")) {
        if(lua_istable (_L, 3)) {
	    GLfloat pixels[N], a, b;
	    GLenum error;

	    for (i = 0 ; i < N ; i += 1) {
		pixels[i] = 0;
	    }
	    
	    lua_pushnil(_L);
	    while (lua_next(_L, 3) != 0) {
		a = lua_tonumber (_L, -2);
		b = pixels [(int)(a * N)];
		
		for (i = (int)(a * N) ; i < N && pixels[i] == b ; i += 1) {
		    pixels[i] = lua_tonumber (_L, -1);
		}
		
		lua_pop(_L, 1);
	    }
	    
	    glGetError();
	    glDeleteTextures (1, &self->intensity);
	    glGenTextures(1, &self->intensity);
	    glBindTexture(GL_TEXTURE_1D, self->intensity);
    
	    glTexParameteri(GL_TEXTURE_1D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
	    glTexParameteri(GL_TEXTURE_1D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);

	    glTexParameteri(GL_TEXTURE_1D, GL_TEXTURE_WRAP_S, GL_CLAMP);

	    glTexImage1D (GL_TEXTURE_1D,
			  0,
			  GL_LUMINANCE, 32, 0,
			  GL_LUMINANCE,
			  GL_FLOAT,
			  pixels);
		
	    error = glGetError();
	    if(error != GL_NO_ERROR) {
		printf ("Could not create cel texture (%s)\n",
			(char *)gluErrorString(error));
		abort();
	    }
        }
    } else if (!xstrcmp(k, "ambience")) {
	self->ambience = lua_tonumber (_L, -1);
    } else {
	[super set];
    }
}

@end

