/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include "observer.h"

@implementation Observer

/* -(void) transform */
/* { */
/*     id root; */
/*     GLfloat *R, *S, T[16], Q[9]; */

/*     [super transform]; */

/*     for (root = self ; [root parent] ; root = [root parent]); */

/*     R = [root homogenous]; */
/*     S = [self homogenous]; */

/*     T[0] = R[0]; */
/*     T[1] = R[4]; */
/*     T[2] = R[8]; */
/*     T[3] = 0; */
    
/*     T[4] = R[1]; */
/*     T[5] = R[5]; */
/*     T[6] = R[9]; */
/*     T[7] = 0; */
    
/*     T[8] = R[2]; */
/*     T[9] = R[6]; */
/*     T[10] = R[10]; */
/*     T[11] = 0; */

/*     T[12] = -R[0] * R[12] - R[1] * R[13] - R[2] * R[14]; */
/*     T[13] = -R[4] * R[12] - R[5] * R[13] - R[6] * R[14]; */
/*     T[14] = -R[8] * R[12] - R[9] * R[13] - R[10] * R[14]; */
/*     T[15] = 1; */

/*     glMatrixMode (GL_MODELVIEW); */
/*     glPushMatrix (); */
    
/*     glLoadMatrixf (T); */
/*     glMultMatrixf (S); */
/*     glGetFloatv (GL_MODELVIEW_MATRIX, T); */
    
/* /\*     printf ("%f, %f, %f, %f,\n" *\/ */
/* /\* 	    "%f, %f, %f, %f,\n" *\/ */
/* /\* 	    "%f, %f, %f, %f,\n" *\/ */
/* /\* 	    "%f, %f, %f, %f\n\n", *\/ */
/* /\* 	    T[0], T[1], T[2], T[3], *\/ */
/* /\* 	    T[4], T[5], T[6], T[7], *\/ */
/* /\* 	    T[8], T[9], T[10], T[11], *\/ */
/* /\* 	    T[12], T[13], T[14], T[15]); *\/ */

/*     glLoadIdentity (); */

/*     gluLookAt (T[12], T[13], T[14], */
/* 	       T[12] - T[8], T[13] - T[9], T[14] - T[10], */
/* 	       -T[0], -T[1], -T[2]); */

/*     glGetFloatv (GL_MODELVIEW_MATRIX, T); */
/*     glPopMatrix(); */

/*     Q[0] = T[0]; */
/*     Q[1] = T[4]; */
/*     Q[2] = T[8]; */
    
/*     Q[3] = T[1]; */
/*     Q[4] = T[5]; */
/*     Q[5] = T[9]; */
    
/*     Q[6] = T[2]; */
/*     Q[7] = T[6]; */
/*     Q[8] = T[10]; */
    
/*     [root setPositionTo: &T[12]]; */
/*     [root setOrientationTo: Q]; */
/* } */

-(void) transform
{
    GLfloat *M;

    [super transform];

    glMatrixMode (GL_MODELVIEW);
/*     glPushMatrix (); */
    glLoadIdentity ();

    M = [self homogenous];

    gluLookAt (M[12], M[13], M[14],
	       M[12] - M[8], M[13] - M[9], M[14] - M[10],
	       -M[0], -M[1], -M[2]);

    glGetFloatv (GL_MODELVIEW_MATRIX, self->lookat);
/*     glPopMatrix(); */
}

/* -(void) prepare */
/* { */
/*     glMatrixMode (GL_MODELVIEW); */
/*     glPushMatrix(); */
/*     glLoadMatrixf (self->lookat); */

/*     [super prepare]; */
/* } */

/* -(void) cleanup */
/* { */
/*     glMatrixMode (GL_MODELVIEW); */
/*     glPopMatrix(); */

/*     [super cleanup]; */
/* } */

@end
