/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>

#define UNPACK(type, c)				\
    {						\
	int i, n;				\
	type *data;				\
						\
	luaL_checkstring (_L, 1);		\
	lua_newtable (_L);			\
						\
	data = (type *)lua_tostring (_L, 1);		\
	n = lua_strlen (_L, 1) / sizeof (type);		\
							\
	for (i = 0 ; i < n ; i += 1) {			\
	    lua_pushnumber (_L, c * data[i]);		\
	    lua_rawseti (_L, 2, i + 1);			\
	}						\
    }

static int unpackfloats(lua_State *L)
{
    UNPACK(float, 1.0);
    
    return 1;
}

static int unpackushorts(lua_State *L)
{
    UNPACK(unsigned short, 1.0);
    
    return 1;
}

static int unpackshorts(lua_State *L)
{
    UNPACK(short, 1.0);
    
    return 1;
}

static int unpackints(lua_State *L)
{
    UNPACK(int, 1.0);
    
    return 1;
}

static int unpackuints(lua_State *L)
{
    UNPACK(unsigned int, 1.0);
    
    return 1;
}

static int unpackchars(lua_State *L)
{
    UNPACK(char, 1.0);
    
    return 1;
}

static int unpackuchars(lua_State *L)
{
    UNPACK(unsigned char, 1.0);
    
    return 1;
}

static int unpackbytes(lua_State *L)
{
    UNPACK(char, 1.0 / CHAR_MAX);
    
    return 1;
}

static int unpackubytes(lua_State *L)
{
    UNPACK(unsigned char, 1.0 / UCHAR_MAX);
    
    return 1;
}

int luaopen_pack (lua_State *L)
{
    const luaL_Reg pack[] = {
	{"fromfloats", unpackfloats},
	{"fromshorts", unpackshorts},
	{"fromunsignedshorts", unpackushorts},
	{"fromints", unpackints},
	{"fromunsignedints", unpackuints},
	{"fromchars", unpackchars},
	{"fromunsignedchars", unpackuchars},
	{"frombytes", unpackbytes},
	{"fromunsignedbytes", unpackubytes},
	{NULL, NULL}
    };

    luaL_register (L, "pack", pack);

    return 0;
}
