/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <GL/glext.h>
#include "texture.h"
#include "parametric.h"
#include "light.h"

static const GLchar *header =
"uniform float parameter[];			           \n"
"#line 1						   \n";

@implementation Parametric

-(Parametric *)init
{
    self->parametric.values = NULL;
    self->parametric.array = glGetUniformLocationARB (self->program,
						      "parameter");
    
    [super init];

    return self;
}

-(void)attachVertexSource: (const GLchar *)source
{
    GLchar *newsource;

    newsource = alloca(strlen(header) + strlen(source) + 2);

    strcpy (newsource, header);
    strcat (newsource, source);

    [super attachVertexSource: (const GLchar *)newsource];
}

-(void)attachFragmentSource: (const GLchar *)source
{
    GLchar *newsource;

    newsource = alloca(strlen(header) + strlen(source) + 2);

    strcpy (newsource, header);
    strcat (newsource, source);
    
    [super attachFragmentSource: (const GLchar *)newsource];
}

-(void) get
{
    const char *k;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "parameter")) {
	lua_getmetatable (_L, 1);
	lua_replace (_L, 1);
	lua_gettable (_L, 1);
    } else {
	[super get];
    }
}

-(void) set
{    
    const char *k;
    int i;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "parameter")) {
        if(lua_istable (_L, 3)) {
	    int n;

	    n = lua_objlen (_L, 3);

	    self->parametric.size = n;
	    self->parametric.values = realloc (self->parametric.values,
					       n * sizeof(GLfloat));
	    
            for(i = 0 ; i < n ; i += 1) {
                lua_rawgeti (_L, 3, i + 1);
                self->parametric.values[i] = lua_tonumber (_L, -1);
                
                lua_pop (_L, 1);
            }
        } else if(lua_isnumber (_L, 3)) {
	    self->parametric.size = 1;
	    self->parametric.values = realloc (self->parametric.values,
					       sizeof(GLfloat));
	    
	    self->parametric.values[0] = lua_tonumber (_L, 3);
	}

	lua_getmetatable (_L, 1);
	lua_replace (_L, 1);
	lua_settable (_L, 1);
    } else {
	[super set];
    }
}

-(void)traversePass: (int) pass
{
    glUniform1fvARB (self->parametric.array,
		     self->parametric.size,
		     self->parametric.values);

    [super traversePass: pass];
}

@end
