/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <ode/ode.h>
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>

#include "slider.h"
#include "body.h"

@implementation Slider

-(Joint *) init
{
    [super init];

    self->joint = dJointCreateSlider (_WORLD, NULL);

    self->stops[0] = -dInfinity;
    self->stops[1] = dInfinity;

    self->axis[0] = 0;
    self->axis[1] = 0;
    self->axis[2] = 1;

    return self;
}

-(void) get
{
    const char *k;
    int i;
    
    k = lua_tostring (_L, -1);

    if (!xstrcmp(k, "axis")) {
        lua_newtable (_L);
        
        for(i = 0; i < 3; i += 1) {
            lua_pushnumber (_L, self->axis[i]);
            lua_rawseti (_L, -2, i + 1);
        }
    } else if (!xstrcmp(k, "motor")) {
        lua_newtable (_L);
        
        for(i = 0; i < 2; i += 1) {
            lua_pushnumber (_L, self->motor[i]);
            lua_rawseti (_L, -2, i + 1);
        }
    } else if (!xstrcmp(k, "stops")) {
        lua_newtable (_L);

        lua_newtable (_L);
        for(i = 0; i < 2; i += 1) {
            lua_pushnumber (_L, self->stops[i]);
            lua_rawseti (_L, -2, i + 1);
        }
	lua_rawseti (_L, -2, 1);
	
        lua_newtable (_L);
        for(i = 0; i < 2; i += 1) {
            lua_pushnumber (_L, self->hardness[i]);
            lua_rawseti (_L, -2, i + 1);
        }
	lua_rawseti (_L, -2, 2);

	lua_pushnumber (_L, self->bounce);
	lua_rawseti (_L, -2, 3);
    } else if (!xstrcmp(k, "tolerance")) {
	lua_pushnumber (_L, self->tolerance);
    } else if (!xstrcmp(k, "fudge")) {
	lua_pushnumber (_L, self->fudge);
    } else if (!xstrcmp(k, "state")) {
	dReal state[2];

	if ([self joint]) {
	    state[0] = dJointGetSliderPosition ([self joint]);
	    state[1] = dJointGetSliderPositionRate ([self joint]);

	    lua_newtable (_L);
        
	    for(i = 0 ; i < 2 ; i += 1) {
		lua_pushnumber (_L, state[i]);
		
		lua_rawseti (_L, -2, i + 1);
	    }
	} else {
	    lua_pushnil (_L);
	}
    } else {
	[super get];
    }
}

-(void) set
{
    const char *k;
    int i;

    k = lua_tostring (_L, -2);

    if (!xstrcmp(k, "axis")) {
        if(lua_istable (_L, 3)) {
            for(i = 0 ; i < 3 ; i += 1) {
                lua_rawgeti (_L, 3, i + 1);
                self->axis[i] = lua_tonumber (_L, -1);
                
                lua_pop (_L, 1);
            }

	    dSafeNormalize3 (self->axis);
	    
	    if(dJointGetBody([self joint], 0) ||
	       dJointGetBody([self joint], 1)) {
		dJointSetSliderAxis ([self joint],
				     self->axis[0],
				     self->axis[1],
				     self->axis[2]);
	    }
        }
    } else if (!xstrcmp(k, "motor")) {
        if(lua_istable (_L, 3)) {
            for(i = 0 ; i < 2 ; i += 1) {
                lua_rawgeti (_L, 3, i + 1);
                self->motor[i] = lua_tonumber (_L, -1);
                
                lua_pop (_L, 1);
            }

	    dJointSetSliderParam ([self joint], dParamVel, self->motor[0]);
	    dJointSetSliderParam ([self joint], dParamFMax, self->motor[1]);
	}
    } else if (!xstrcmp(k, "stops")) {
        if(lua_istable (_L, 3)) {
	    lua_rawgeti (_L, 3, 1);
	    for(i = 0 ; i < 2 ; i += 1) {
		lua_rawgeti (_L, -1, i + 1);
		
		self->stops[i] = lua_tonumber (_L, -1);
		
		lua_pop (_L, 1);
	    }
	    lua_pop (_L, 1);

	    lua_rawgeti (_L, 3, 2);
	    for(i = 0 ; i < 2 ; i += 1) {
		lua_rawgeti (_L, -1, i + 1);

		self->hardness[i] = lua_tonumber (_L, -1);

		lua_pop (_L, 1);
	    }
	    lua_pop (_L, 1);
	
	    lua_rawgeti (_L, 3, 3);
	    self->bounce = lua_tonumber (_L, -1);
	    lua_pop (_L, 1);

	    /* Resetting the stops makes sure that lo remains
	       smaller than hi between calls. */
	
	    dJointSetSliderParam ([self joint], dParamLoStop, -dInfinity);
	    dJointSetSliderParam ([self joint], dParamHiStop, dInfinity);

	    dJointSetSliderParam ([self joint], dParamLoStop,
				  self->stops[0]);
	    dJointSetSliderParam ([self joint], dParamHiStop,
				  self->stops[1]);
	    dJointSetSliderParam ([self joint], dParamStopCFM,
				  self->hardness[0]);
	    dJointSetSliderParam ([self joint], dParamStopERP,
				  self->hardness[1]);
	    dJointSetSliderParam ([self joint], dParamBounce, self->bounce);
	}
    } else if (!xstrcmp(k, "fudge")) {
	self->fudge = lua_tonumber (_L, 3);

	dJointSetSliderParam ([self joint], dParamFudgeFactor, self->fudge);
    } else if (!xstrcmp(k, "tolerance")) {
	self->tolerance = lua_tonumber (_L, 3);

	dJointSetSliderParam ([self joint], dParamCFM, self->tolerance);
    } else if (!xstrcmp(k, "bodies")) {
	[super set];

	/* Reset the axis to update the initial
	   sider position. */
	
	if(dJointGetBody([self joint], 0) ||
	   dJointGetBody([self joint], 1)) {
	    dJointSetSliderAxis ([self joint],
				 self->axis[0],
				 self->axis[1],
				 self->axis[2]);
	}
    } else {
	[super set];
    }
}

@end
