-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "network"
require "resources"
require "derived"
require "aviation"
require "nature"
require "widgets"
require "shapes"
require "shading"
require "transforms"
require "frames"
require "moremath"
require "moremeshes"
require "particulate"
require "physics"
require "units"

-- These values are fixed.

graphics.title = "Techne"
graphics.window = {800, 600}
graphics.hide = true
graphics.canvas = {0.07, 0.07, 0.075}

derived.gee = units.meters(-9.81)
derived.range = units.meters{0.1, 100000}
derived.field = 47

dynamics.collision = {}
dynamics.tolerance = {1e-6, 0.2}
dynamics.popvelocity = 10
dynamics.surfacelayer = 1e-2
dynamics.stepsize = 0.01

resources.dofile "scripts/atmosphere.lua"
resources.dofile "scripts/kolmogorov.lua"

graphics.close = function ()
		    common.iterate = false
		 end
   
graph.events = frames.event {
   keypress = function(self, key)
		 if key == 'q' then
		    common.iterate = false
		 end
	      end
}

graph.framerate = options.framerate and widgets.display {
   size = {graphics.window[1] / graphics.window[2], 1},
   align = {1, 1},

   gauge = widgets.clock {
      padding = {0.01, 0.01},
      color = {1.0, 0.8, 0.2},
      opacity = 0.6,
      
      radius = {0.07, 0.05},
      range = {0, 220},
      spacing = {5, 4},
      spread = {-4 * math.pi / 5, 3 * math.pi / 5},

      frames.timer {
	 period = 0.2,
	 frames = 0,

	 tick = function (self, tick, delta, elapsed)
		   self.parent.reading = (graphics.frames - self.frames) / delta
		   self.frames = graphics.frames
		end
      },

      [1] = resources.faces.small {text = "0"},
      [2] = resources.faces.small {text = "20"},
      [3] = resources.faces.small {text = "40"},
      [4] = resources.faces.small {text = "60"},
      [5] = resources.faces.small {text = "80"},
      [7] = resources.faces.small {text = "120"},
      [9] = resources.faces.small {text = "160"},
      [11] = resources.faces.small {text = "200"},
   },
}
