-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "frames"

local pipe

if options.tape then
   graph.encoder = frames.transform {
      prepare = function (self)
         local command

	 command = string.format ("mencoder /dev/stdin -really-quiet -demuxer rawvideo -rawvideo w=%d:h=%d:format=rgba:fps=%d -flip -ovc x264 -x264encopts pass=1:turbo:frameref=6:analyse=all:me=umh:subme=4:trellis=1:bframes=1:subq=5:mixed_refs:weight_b:nofast_pskip:direct_pred=auto:nr=200:bitrate=%d%s -o %s", graphics.window[1],
				  graphics.window[2],
				  options.encodingframerate or 24,
				  options.encodingbitrate or 4000,
				  options.encodingpass and
				     string.format (":pass=%d",
						    options.encodingpass) or
				  "",
			       options.tape)

	 -- command = [[ffmpeg -an -pix_fmt rgba -r 60 -s 800x600 -f rawvideo -i - -vcodec libx264 -f h264 -b 8000k -vpre slow -y /tmp/tape.mpg]]

	 print(string.format ("Output is being recorded using " ..
			      "the command:\n%s", command))

	 pipe = io.popen (command, "w")

	 self.prepare = nil
      end,
      
      unlink = function (self)
		  io.close (pipe)
	       end,
		      
      finish = function (self, tick, delta, elapsed)
		  pipe:write (tostring(graphics.colorbuffer))
	       end
   }
end
