/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include "breaker.h"

@implementation Breaker

-(Breaker *) init
{
    char *list[] = {"selected"};
    
    self = [super init];
    [self add: sizeof (list) / sizeof (char *) Properties: list];

    self->target = 0;
    self->state = 0;
    self->reference = LUA_REFNIL;
    
    return self;
}

-(void) link
{
	/* Link the selected node to ourselves. */
	
	if (self->reference != LUA_REFNIL) {    
	    lua_rawgeti (_L, LUA_REGISTRYINDEX, self->reference);
	    lua_pushliteral (_L, "parent");

	    lua_getfield (_L, LUA_REGISTRYINDEX, "userdata");
	    lua_pushlightuserdata (_L, self);
	    lua_gettable (_L, -2);
	    lua_replace (_L, -2);

	    lua_settable (_L, -3);
	    lua_pop (_L, 1);
	}
	
	self->state = 1;
}

-(void) unlink
{
	/* Unlink the selected node from ourselves. */
	
	if (self->reference != LUA_REFNIL) {    
	    lua_rawgeti (_L, LUA_REGISTRYINDEX, self->reference);
	    lua_pushliteral (_L, "parent");
	    lua_pushnil (_L);
	    lua_settable (_L, -3);
	    lua_pop (_L, 1);
	}
	
	self->state = 0;
}

-(void) finish
{
    if (self->target && !self->state) {
	[self link];
    }

    if (!self->target && self->state) {
	[self unlink];
    }
    
    [super finish];
}

-(void) get
{
    const char *k;
    
    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "selected")) {
        lua_rawgeti (_L, LUA_REGISTRYINDEX, self->reference);
    } else {
	[super get];
    }
}

-(void) set
{
    const char *k;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "selected")) {
	/* Make sure we're unlinked. */

	[self unlink];

	self->selected = *(id *)lua_touserdata(_L, 3);
	
        luaL_unref (_L, LUA_REGISTRYINDEX, self->reference);
        self->reference = luaL_ref (_L, LUA_REGISTRYINDEX);

	/* Link if needed. */
	
	if (self->target > 0) {
	    [self link];
	}
    } else {
	[super set];
    }
}

@end
