/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include "origin.h"

@implementation Origin

-(void) transform
{
    self->transformed = 1;

    [super transform];
}

-(void) prepare
{
    id root;

    if (self->transformed) {
	for (root = self ; [root parent] ; root = [root parent]);

	/*  Compute a matrix to translate the origin of the
	    coordinate system at our position and store this
	    matrix in the root node. */
    
	/* printf ("before: %f, %f, %f\n", */
	/* 	[self translation][0], */
	/* 	[self translation][1], */
	/* 	[self translation][2]); */

	[root transformRelativeTo: [self translation]];
    
	/* printf ("after: %f, %f, %f\n", */
	/* 	[self translation][0], */
	/* 	[self translation][1], */
	/* 	[self translation][2]); */
    }
    
    [super prepare];
}

-(void) finish
{
    self->transformed = 0;

    [super finish];
}
    
@end
