/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <AL/al.h>
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>
#include <time.h>

#include "sample.h"

@implementation Sample

-(Sample *) init
{
    [super init];

    alSourceQueueBuffers(self->index, 1, &self->name);

    return self;
}

-(Sample *) initWithSamples: (ALshort *) samples
                     ofSize: (int) n
	        atFrequency: (int) f;
{
    ALenum error;
    ALuint buffer;

    [super init];
        
    alGetError();
    alGenBuffers(1, &buffer);
    alBufferData (buffer, AL_FORMAT_MONO16, samples, 2 * n, f);

    error = alGetError();
    if(error != AL_NO_ERROR) {
	printf ("Could not create sample buffer (%s).\n",
		alGetString(error));
    }
    
    self->name = buffer;
    self->size = n;
    self->frequency = f;
 
    return self;
}

-(void) freeBuffers
{
    alDeleteBuffers(1, &self->name);

    [super free];
}

-(int) length
{
    return self->size;
}

-(int) frequency
{
    return self->frequency;
}

@end
