/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <ode/ode.h>
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>

#include "body.h"
#include "thruster.h"

char *list[] = {
    "ancestry", "finish", "input", "link", "parent", "prepare",
    "step", "tag", "transform", "traverse", "unlink",
};

@implementation Thruster

-(Thruster *) init
{
    char *list[] = {"thrust"};

    [super init];
    [self add: sizeof (list) / sizeof (char *) Properties: list];

    self->thrust = 1000;
  
    return self;
}

-(void) stepBy: (double) h at: (double) t
{
    double *r, *R;

    r = [self position];
    R = [self orientation];

    dBodyAddRelForceAtRelPos ([[self parent] body],
			      self->thrust * R[2],
			      self->thrust * R[5],
			      self->thrust * R[8],
			      r[0], r[1], r[2]);

/*     printf ("%f, %f, %f\n",   self->thrust * R[2], */
/* 			      self->thrust * R[5], */
/* 			      self->thrust * R[8]); */
    
    [super stepBy: h at: t];
}

-(void) get
{
    const char *k;
    
    k = lua_tostring(_L, -1);

    if (!xstrcmp(k, "thrust")) {
	lua_pushnumber(_L, self->thrust);
    } else {
	[super get];
    }
}

-(void) set
{
    const char *k;

    k = lua_tostring(_L, -2);

    if (!xstrcmp(k, "thrust")) {
	self->thrust = lua_tonumber(_L, 3);
    } else {
	[super set];
    }
}

@end
