-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "dynamics"
require "physics"
require "moremath"

springs = {}
servos = {}

function springs.linear (values)
   local meta, self, oldindex, oldnewindex

   self = joints.slider {
      attach = function (self, a, b)
		  if a and b then
		     self.axis = math.normalize(math.subtract(a.position,
							      b.position))
		  end
	       end,
  }

   meta = getmetatable (self)

   meta.stiffness = 100
   meta.damping = 10
   meta.preload = 0

   oldindex = meta.__index
   oldnewindex = meta.__newindex

   meta.__index = function (self, key)
		     local meta = getmetatable(self)

		     if key == "stiffness" then
			return meta.stiffness
		     elseif key == "damping" then
			return meta.damping
		     elseif key == "preload" then
			return meta.preload
		     else
			return oldindex (self, key)
		     end
		  end

   meta.__newindex = function (self, key, value)
      local meta = getmetatable(self)

      if key == "stiffness" then
	 meta.stiffness = value
      elseif key == "damping" then
	 meta.damping = value
      elseif key == "preload" then
	 meta.preload = value
      else
	 oldnewindex(self, key, value)
      end

      if key == "stiffness" or
	 key == "damping" then
	 local stops = self.stops

	 stops[2] = physics.spring (meta.stiffness, meta.damping)
	 self.stops = stops
      end

      if key == "preload" then
	 local stops = self.stops

	 stops[1] = {meta.preload, meta.preload}
	 self.stops = stops
      end
   end

   meta.__tostring = function(self)
			 return "Linear"
		      end

   self.stiffness = 100
   self.damping = 10
   self.preload = 0

   for key, value in pairs(values) do
      self[key] = value
   end

   return self
end

function springs.euler (values)
   local meta, self, oldindex, oldnewindex

   self = joints.spherical {
      -- step = function (self)
      -- 		local meta = getmetatable(self)
      -- 		local reset

      -- 		for i = 1, 3 do
      -- 		   if (self.state[i] >= 0.5 * math.pi and
      -- 		       meta.preload[i] - meta.rest[i] >= 0.5 * math.pi) or
      -- 		      (self.state[i] <= -0.5 * math.pi and 
      -- 		       meta.preload[i] - meta.rest[i] <= -0.5 * math.pi) then
      -- 		      reset = true
      -- 		   end		
      -- 		end

      -- 		if reset then
      -- 		   meta.rest = {
      -- 		      meta.rest[1] + self.state[1],
      -- 		      meta.rest[2] + self.state[2],
      -- 		      meta.rest[3] + self.state[3],
      -- 		   },

      -- 		   physics.reattach (self)

      -- 		   self.preload = self.preload
      -- 		end
      -- 	     end
   }

   meta = getmetatable (self)

   meta.stiffness = {100, 100, 100}
   meta.damping = {10, 10, 10}
   meta.preload = {0, 0, 0}

   oldindex = meta.__index
   oldnewindex = meta.__newindex

   meta.__index = function (self, key)
		     local meta = getmetatable(self)

		     if key == "stiffness" then
			return meta.stiffness
		     elseif key == "damping" then
			return meta.damping
		     elseif key == "preload" then
			return meta.preload
		     else
			return oldindex (self, key)
		     end
		  end

   meta.__newindex = function (self, key, value)
      local meta = getmetatable(self)

      if key == "stiffness" then
	 meta.stiffness = value
      elseif key == "damping" then
	 meta.damping = value
      elseif key == "preload" then
	 meta.preload = value
      else
	 oldnewindex(self, key, value)
      end

      if key == "stiffness" or
	 key == "damping" then
	 local k_s = meta.stiffness
	 local k_d = meta.damping
	 local stops = self.stops

	 if type(k_s) == "number" then
	    k_s = {k_s, k_s, k_s}
	 end

	 if type(k_d) == "number" then
	    k_d = {k_d, k_d, k_d}
	 end

	 for i = 1, 3 do
	    stops[i][2] = physics.spring (k_s[i], k_d[i])
	 end

	 self.stops = stops
      end

      if key == "preload" then
	 local stops = self.stops
	 local delta = {
	    meta.preload[1],
	    meta.preload[2],
	    meta.preload[3]
	 }

	 for i = 1, 3 do
	    stops[i][1] = {delta[i], delta[i]}
	 end

	 self.stops = stops
      end
   end

   meta.__tostring = function(self)
			 return "Euler"
		      end

   self.stiffness = {100, 100, 100}
   self.damping = {10, 10, 10}
   self.preload = {0, 0, 0}
   
   for key, value in pairs(values) do
      self[key] = value
   end

   return self
end
