-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local function serialize(value)
   if type(value) == "string" then
      return string.format ("%q", value)
   elseif type(value) == "table" then
      local serialized, fields = {}, {}

      for i, element in ipairs (value) do
	 table.insert (fields, string.format ("%s,", serialize(element)))

	 serialized[i] = true
      end

      for key, element in pairs (value) do
	 if not serialized[key] then
	    table.insert (fields, string.format ("[%s] = %s,",
						 serialize(key),
						 serialize(element)))
	 end
      end
      
      return "{" .. table.concat(fields) .. "}"
   elseif type(value) == "number" then
      return string.format ("%.17g", value)
   else
      return tostring(value)
   end
end

string.serialize = serialize
