-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "textures"

function textures.checkerboard (w, h, n)
   local pixels = {}

   for j = 0, h - 1 do
      for i = 0, w - 1 do
	 pixels[j * w + i + 1] =
	    (math.floor(j * n / h) + math.floor(i * n / w)) % 2
      end
   end

   return  {
      size = {w, h, 1}, 
      pixels = pixels
   }
end
