-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "network"
require "frames"
require "imaging"
require "pack"

local profiler = frames.timer {
   period = options.profilingrate and 1 / options.profilingrate or 1,

   sum = {},
   samples = {},

   link = function(self)
	     for i = 1, #configuration.iteration do
		self.sum[i] = 0
		self.samples[i] = 0
	     end
	  end,

   finish = function (self)
	       for i = 1, #configuration.iteration do
		  self.sum[i] = self.sum[i] + configuration.iteration[i]
		  self.samples[i] = self.samples[i] + 1
	       end
	    end,

   tick = function (self, tick, delta, elapsed)
	     for i = 1, #configuration.iteration do
		configuration.averages[i] = 1000 * self.sum[i] / self.samples[i]		      

		self.sum[i] = 0
		self.samples[i] = 0
	     end
	  end,
}

configuration.averages = {}
profiler.parent = graph

network.mime["/buffers/color"] = "image/png"
network.pages["/buffers/color"] =
   function (method, uri, version)
      local image
      local w, h

      w, h = graphics.window[1], graphics.window[2]

      image = imaging.flip (graphics.colorbuffer, w, h)
      image = imaging.writeformat (image, w, h, "PNG")

      return image
   end

network.mime["/buffers/depth"] = "image/png"
network.pages["/buffers/depth"] =
   function (method, uri, version)
      local image
      local w, h

      w, h = graphics.window[1], graphics.window[2]

      image = imaging.autolevel (graphics.depthbuffer, w, h)
      image = imaging.flip (image, w, h)
      image = imaging.writeformat (image, w, h, "PNG")

      return image
   end

network.mime["/buffers/stencil"] = "image/png"
network.pages["/buffers/stencil"] =
   function (method, uri, version)
      local image
      local w, h

      w, h = graphics.window[1], graphics.window[2]

      image = imaging.autolevel (graphics.stencilbuffer, w, h)
      image = imaging.flip (image, w, h)
      image = imaging.writeformat (image, w, h, "PNG")

      return image
   end

network.mime["/techne"] = "text/html"
network.pages["/techne"] = [=[
<head>
  <title>Techne</title>
    <style type="text/css">
      body {
	 background-color: #bdb76b;
      }

      div {
	 font-family: typewriter;
	 width: 500px;
	 background-color: white;
	 border-width: thin;
	 border-style: dotted;
	 border-color: #bdb76b;
	 padding: 5px;
	 margin: 10px;
      }
   
      table {
	 background-color: white;
      }
      
      th, td {
	 text-align: left;
	 padding-right:30px;
      }
   </style>
   <script type="text/javascript">
    xmlhttp = new XMLHttpRequest();

    function update()
    {
       filter = document.getElementById("filter");
       filter = filter.options[filter.selectedIndex].value;
       if (filter) {
	  filter = '?class=' + filter;
       }

       path = document.getElementById("path");
       path = path.value;
       if (path) {
	  path = (filter ? '&' : '?') + 'node=' + path;
       }

       xmlhttp.open("GET", "/techne/xml" + filter + path, false);
       xmlhttp.send();
       xml = xmlhttp.responseXML;

       cells = document.getElementById("time").rows[1].cells;
       intervals = xml.getElementsByTagName("time")[0]
                      .getElementsByTagName("interval");

       for (i = 0 ; i < 3 ; i += 1) {
	  cells[i].firstChild.nodeValue =
	     intervals[i].firstChild.nodeValue;
       }

       cells = document.getElementById("iteration").getElementsByTagName("td");
       intervals = xml.getElementsByTagName("iteration")[0]
                      .getElementsByTagName("interval");

       for (i = 0 ; i < cells.length ; i += 1) {
	  id = parseInt (cells[i].id);

	  if (!isNaN(id)) {
	     cells[i].firstChild.nodeValue = intervals[id].firstChild.nodeValue;
	  }
       }

       cells = document.getElementById("nodes").rows[1].cells;
       counts = xml.getElementsByTagName("nodes")[0]
                      .getElementsByTagName("count");

       for (i = 0 ; i < 3 ; i += 1) {
	  cells[i + 1].firstChild.nodeValue = counts[i].firstChild.nodeValue;
       }

       document.getElementById("class").firstChild.nodeValue = 
         xml.getElementsByTagName("node")[0].getAttribute ("class");

       table = document.getElementById("node");
       properties = xml.getElementsByTagName("node")[0]
                       .getElementsByTagName("property");

       while (table.rows.length > 1) {
	  table.deleteRow(1);
       }

       for (i = 0 ; i < properties.length ; i += 1) {
	  key = properties[i].getAttribute("name");
	  value = properties[i].firstChild.nodeValue;

	  row = table.insertRow (i + 1);

	  row.insertCell(0).appendChild(document.createTextNode(key));
	  row.insertCell(1).appendChild(document.createTextNode(value));
       }

       setTimeout ("update()", 1000);
    }
</script>
</head>

<body onLoad="javascript: update()">
  <div>
    <h3>Time</h3>
    <table id="time">
      <tr><th>Simulation</th><th>Real</th><th>Process</th></tr>
      <tr><td id="simulation">-</td>
          <td id="real">-</td>
	  <td id="process">-</td>
      </tr> 
    </table>
  </div>

  <div>
    <h3>Iteration profile</h3>
    <table id="iteration">
      <tr><th>Phase</th><th>Core</th><th>User</th></tr>
      <tr><td>input</td><td id="0">-</td><td id="11">-</td></tr> 
      <tr><td>begin</td><td id="1">-</td><td id="12">-</td></tr> 
      <tr><td>transform</td><td id="2">-</td><td id="13">-</td></tr> 
      <tr><td>collide</td><td id="3">-</td><td id="14">-</td></tr> 
      <tr><td>step</td><td id="4">-</td><td id="15">-</td></tr> 
      <tr><td>integrate</td><td id="5">-</td><td>-</td></tr>  
      <tr><td>prepare</td><td id="6">-</td><td id="16">-</td></tr> 
      <tr><td>pass</td><td id="7">-</td><td id="17">-</td></tr> 
      <tr><td>repass</td><td id="8">-</td><td id="18">-</td></tr> 
<tr><td>finish</td><td id="9">-</td><td id="19">-</td></tr> 
      <tr><td>total</td><td id="10">-</td><td id="20">-</td></tr>   
    </table>
  </div>

  <div>
    <h3>Nodes</h3>
    <table id="nodes">
      <tr><th>Class</th><th>Allocated</th><th>Linked</th><th>Unlinked</th></tr>
      <tr><td><select id="filter">
              <?lua
                 local classes = {}
                 local html = [[
              <option value="" selected=true>Any</option>
]]

                 for class, _ in pairs(configuration.nodes) do
		    table.insert (classes, class)
		 end

		 table.sort (classes)

		 for i = 1, #classes do
		    html = html .. string.format([[
              <option value="%s">%s</option>
]], classes[i], classes[i])
		 end

		 return html
               ?>		    
              </select>
          <td> - </td>
          <td> - </td>
          <td> - </td>
      </tr>
    </table>
  </div>

  <div>
    <h3><span id="class">-</span> at: 
       <input id="path" type="text" value="graph"/></h3>

    <table id="node">
      <tr><th>Property</th><th>Value</th></tr>
    </table>
  </div>
</body>
]=]

network.mime["/techne/xml"] = "text/xml"
network.pages["/techne/xml"] = [=[
<?xml version="1.0"?>
<resources>
  <time>
    <?lua
      html = ""

      for i = 1, 3 do
	 html = html .. string.format([[
    <interval>%.4f</interval>
]], configuration.time[i])
      end

      return html
     ?>
  </time>
  <iteration>
  <?lua
      local s = ""

      for i = 1, #configuration.averages do
	 s = s .. string.format([[
    <interval>%.5f</interval>
]], configuration.averages[i])
      end
      return s
   ?>
  </iteration>
  <nodes>
  <?lua
      local allocated, linked, unlinked = 0, 0, 0
      local filter

      if query.class then
	 filter = {[query.class] = configuration.nodes[query.class]}
      else
	 filter = configuration.nodes
      end

      for class, list in pairs (filter) do
	 for i = 1, #list do
	    allocated = allocated + 1
	    
	    if list[i].linked then
	       linked = linked + 1
	    else
	       unlinked = unlinked + 1
	    end
	 end
      end

      return string.format([[
    <count>%d</count>
    <count>%d</count>
    <count>%d</count>
]], allocated, linked, unlinked)
   ?>
  </nodes>
  <?lua
      local html, node, chunk
      
      local function stringify (value)
	 if type(value) == "string" then
	    return "\"" .. value .. "\""
	 elseif type(value) == "table" then
	    for i, element in ipairs (value) do
	       value[i] = stringify(element) .. ", "
	    end
	    
	    return "{" .. table.concat(value) .. "}"
	 else
	    return tostring(value)
	 end
      end

      if not query.node then
	 query.node = ""
      end

      chunk = loadstring("return " .. query.node)
      node = chunk and chunk()

      if node then
	 html = string.format ([[
  <node class="%s">
]], tostring(node))

	 for key, value in properties (node) do
	    html = html .. string.format ([[
    <property name="%s">%s</property>
]], key, stringify(value))
	 end

	 html = html .. [[
  </node>
]]
      else
	 html = [[
  <node class="Nothing">
  <property name="-">-</property>
  </node>
]]	 
      end

      return html
   ?>
</resources>
]=]
