/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include "display.h"

@implementation Display

-(void) transform
{
    id child;
    
    double zero[3] = {0, 0, 0};
    int v[4];
	
    glGetIntegerv (GL_VIEWPORT, v);

    self->allocated[0] = (double)v[2] / v[3];
    self->allocated[1] = 1;
    
    /* Calculate our own allocation based on our children. */
    
    self->minimum[0] = 2 * self->padding[0];
    self->minimum[1] = 2 * self->padding[1];

    for (child = [self children];
	 child && ![child isKindOf:[Widget class]];
	 child = [child sister]);
    
    if (child) {
	self->minimum[0] += [child measureWidth];
	self->minimum[1] += [child measureHeight];
	
	/* Now align the child properly. */
    
	if (self->align[0] < 0) {
	    [child position][0] = 0.5 * (self->minimum[0] -
					 self->allocated[0]);
	} else if (self->align[0] > 0) {
	    [child position][0] = 0.5 * (self->allocated[0] -
					 self->minimum[0]);
	} else {
	    [child position][0] = 0;
	}

	if (self->align[1] < 0) {
	    [child position][1] = 0.5 * (self->minimum[1] -
					 self->allocated[1]);
	} else if (self->align[1] > 0) {
	    [child position][1] = 0.5 * (self->allocated[1] -
					 self->minimum[1]);
	} else {
	    [child position][1] = 0;
	}

	[child allocated][0] = self->minimum[0] - 2 * self->padding[0];
	[child allocated][1] = self->minimum[1] - 2 * self->padding[1];
    }

    [super transformRelativeTo: zero];
}

-(void) traversePass: (int)pass
{
    if (pass == 2) {
	int v[4];
	
	glMatrixMode (GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();

	glGetIntegerv (GL_VIEWPORT, v);
	glOrtho(-(double)v[2] / v[3] * 0.5,
		(double)v[2] / v[3] * 0.5,
		-0.5, 0.5,
		0, 1);

	glMatrixMode (GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();
	
	glUseProgramObjectARB(0);
	
	[super traversePass: pass];
    
	glMatrixMode (GL_MODELVIEW);
	glPopMatrix();
    
	glMatrixMode (GL_PROJECTION);
	glPopMatrix();
    } else {   
	[super traversePass: pass];
    }
}

@end
