/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _ELEVATION_H_
#define _ELEVATION_H_

#include <lua.h>
#include <GL/gl.h>
#include <ode/ode.h>

#include "roam.h"
#include "transform.h"

@interface Elevation: Transform {
@public
    unsigned short **samples;
    unsigned short **bounds;
    double *scales, *offsets;
    GLuint *imagery;
    int *orders;

    struct block *pools[2];
    
    struct diamond *queues[2][QUEUE_SIZE];
    struct triangle *(*roots)[2];
    
    int size[2], depth;
    double resolution[3], anisotropy;
    
    int blocks[2], chunks[2], queued[2];
    int triangles, diamonds, culled, visible, drawn;
    int minimum, maximum;

    int target;
}

-(Elevation *) initWith: (int)width
		     by: (int)height
	   tilesOfDepth: (int)depth
	  andResolution: (double *) scale;

-(void) loadElevationTile: (int) i
	      withSamples: (unsigned short *)heights
	        andBounds: (unsigned short *)errors
		 ofLength: (int)n
               withOffset: (double)delta
		 andScale: (double)scale;

-(void) loadImageryTile: (int) i
	     withPixels: (unsigned char *)chars
	       ofLength: (int)n;

-(const int *) size;
-(const int) depth;
-(const double *) resolution;
-(void (*)(int, int, double *, double *)) sampler;

-(void) query;

-(void) freeObject;

@end

#endif
