/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <time.h>
#include "flat.h"
#include "texture.h"

@implementation Flat

-(Flat *) init
{
    char *list[] = {"color"};

    [super init];
    [self add: sizeof (list) / sizeof (char *) Properties: list];

    self->texture = nil;
    
    self->color[0] = 1;
    self->color[1] = 1;
    self->color[2] = 1;
    
    return self;
}

-(void) get
{
    const char *k;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "color")) {
	lua_getmetatable (_L, 1);
	lua_replace (_L, 1);
	lua_gettable (_L, 1);
    } else {
	[super get];
    }
}

-(void) set
{    
    const char *k;
    int i;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "color")) {
        if(lua_istable (_L, 3)) {
            for(i = 0 ; i < 3 ; i += 1) {
                lua_rawgeti (_L, 3, i + 1);
                self->color[i] = lua_tonumber (_L, -1);
                
                lua_pop (_L, 1);
            }
	    
	    self->texture = nil;
        } else if(lua_isuserdata (_L, 3)) {
            for(i = 0 ; i < 3 ; i += 1) {
                self->color[i] = 1;
            }
	    
	    self->texture = *(id *)lua_touserdata (_L, 3);
	}

	lua_getmetatable (_L, 1);
	lua_replace (_L, 1);
	lua_settable (_L, 1);
    } else {
	[super set];
    }
}

-(void) traversePass: (int)pass
{
    /* if (pass == 2 && self->color[3] < 1) { */
    /* 	glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA); */
    /* 	glEnable(GL_BLEND); */
	
    /* 	pass = 1; */
    /* } */
    
    if (pass == 1) {
	glUseProgramObjectARB(0);

	if (self->texture) {
	    glActiveTexture (GL_TEXTURE0);
	    glBindTexture (GL_TEXTURE_2D, [self->texture index]);

	    glTexEnvi (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
	    glEnable (GL_TEXTURE_2D);
	}
	
	glColor3fv (self->color);
    
	[super traversePass: pass];

	glDisable (GL_TEXTURE_2D);
	/* glDisable(GL_BLEND); */
    }
}

@end

