/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <GL/glext.h>
#include "texture.h"
#include "glossy.h"
#include "light.h"

static GLuint name;
static const GLchar *vertexSource =
"varying vec3 vertexNormal, vertex;  		      		   	   \n"
"				   		     			   \n"
"void main() 			   		     			   \n"
"{		 		   		     			   \n"
"    vertexNormal = gl_NormalMatrix * gl_Normal;			   \n"
"    vertex = vec3(gl_ModelViewMatrix * gl_Vertex);			   \n"
"				   		     			   \n"
"    gl_Position = ftransform();	     				   \n"
"    gl_TexCoord[0] = gl_TextureMatrix[0] * gl_MultiTexCoord0;		   \n"
"}		 		   		     			   \n";

static const GLchar *fragmentSource = 
"varying vec3 vertexNormal, vertex;      		   	           \n"
"uniform float parameter[3];	   		     			   \n"
"				   		     			   \n"
"void main()                            	     			   \n"
"{	                                	     			   \n"
"    vec3 eye, normal, diffuse, specular, sum, tangent;   	           \n"
"    float c, s, ndote, ndotesquared, fresnel;				   \n"
"    int i;								   \n"
"				   		     			   \n"
"    diffuse = vec3(diffuseSum(gl_TexCoord[0].st));	   		   \n"
"    specular = vec3(specularSum(gl_TexCoord[0].st));	   		   \n"
"			   		     				   \n"
"    c = cos(parameter[2]);						   \n"
"    s = sin(parameter[2]);						   \n"
"			   		     				   \n"
"    eye = normalize(-vertex);   				   	   \n"
"    normal = normalize (vertexNormal);                                    \n"
"    tangent = normalize(vec3(normal.x * normal.z * s + normal.y * c,      \n"
"                        normal.y * normal.z * s - normal.x * c,           \n"
"                        -(1.0 - normal.z * normal.z) * s));               \n"
"				   		     			   \n"
"    ndote = 1.0 - dot(normal, eye);			   	   	   \n"
"    ndotesquared = ndote * ndote;			   	   	   \n"
"				   		     			   \n"
"    fresnel = (1.0 - parameter[1]) * ndotesquared * ndotesquared * ndote +\n"
"	       parameter[1] - 0.1;   		     			   \n"
"				   		     			   \n"
"    sum = mix(diffuse, specular, fresnel) * ambientIntensity(normal);     \n"
"				   		     			   \n"
"    for (i = 0 ; i < lightCount ; i += 1) { 		   		   \n"
"        vec3 light;		   		   			   \n"
"        float ndotl, ldott, edott, nprimedotl, edotr;	   		   \n"
"				   		     			   \n"
"        light = normalize(sourcePosition(i) - vertex); 	   	   \n"
"				   		     			   \n"
"        ndotl = dot(normal, light);			   		   \n"
"        ldott = dot(light, tangent);			   		   \n"
"        edott = dot(eye, tangent);			   		   \n"
"        nprimedotl = sqrt(1.0 - ldott * ldott);			   \n"
"        edotr = max (nprimedotl * sqrt ((1.0 - edott * edott)) -          \n"
"                      ldott * edott, 0.0);                                \n"
"				   		     			   \n"
"        sum += luminousIntensity (i, light) *   	   	   	   \n"
"               shadowFactor (i, vertex) *		   		   \n"
"               attenuationFactor (i, vertex) *		   		   \n"
"               max(mix (nprimedotl * diffuse,                             \n"
"                        pow(edotr, parameter[0]) * specular,		   \n"
"                        fresnel) * ndotl, 0.0);  			   \n"
"    }									   \n"
"				   		     			   \n"
"    gl_FragColor = vec4(befog (sum, vertex), 1.0);			   \n"
"}                                      	     			   \n";

@implementation Glossy

-(Glossy *)init
{
    if (!name) {
	[self build];
	[self verify];

	name = self->program;
    } else {
	self->program = name;
    }

    [super init];
    
    return self;
}

-(void) build
{
    [super build];
    
    [self attachVertexSource: vertexSource];
    [self attachFragmentSource: fragmentSource];
    [self link];
}
    
-(void) traversePass: (int)pass
{
    if (pass == 1) {
	glUseProgramObjectARB(self->program);
	glActiveTexture (GL_TEXTURE0);
    }
    
    [super traversePass: pass];
}

@end
