/* $Id: debugio.h 659 2006-05-13 14:51:08Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#ifndef DEBUGIO_H
#define DEBUGIO_H

#include "nonstdio.h"

/*
 * Streams which can log data written to (or read from) the stream to
 * stderr, for debugging perpose before writing it to (or after reading it
 * from) the underlying stream. 
 */

/* Constant for use as len in functions below, to indicate all data should be output. */
#define DEBUGIO_MAX_LEN (-1)
// size_t is garunteed to be unsigned, so this is the larged possible value

/* debug_io_open_out(base, per_line, buffer, start, len) returns a debugio out stream,
 * or NULL if an errror occured.  All data output on this stream is output to
 * base.  The the len bytes of data starting at start in the stream, are also
 * logged at DEBUG level.  per_line bytes at most are written on each line, and
 * all output is prefixed by pfix.  If buffer is true, data will be buffered until a full line
 * can be output. */
out_stream_t debugio_open_out (out_stream_t, const char *pfix, unsigned, bool,
                               size_t, size_t, bool);

/* As debugio_open_in, but for input streams. */
in_stream_t debugio_open_in (in_stream_t, const char *pfix, unsigned, bool,
                             size_t, size_t, bool);

#endif
