/* $Id: deque.h 659 2006-05-13 14:51:08Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/**
 * A implementation of deques.  Items can be added and removed from either end
 * of the deque.  Items are stored in blocks for efficiency.
 */

#ifndef DEQUE_H
#define DEQUE_H

#include <stdbool.h>
#include <stdlib.h>

typedef struct deque *deque_t;

deque_t create_deque (size_t data_size, size_t block_size);
void release_deque (deque_t deque);

bool is_deque_empty (deque_t deque);

size_t add_to_deque_end (deque_t deque, const void *src, size_t len);
bool single_add_to_deque_end (deque_t deque, const void *src);

size_t add_to_deque_start (deque_t deque, const void *src, size_t len);
bool single_add_to_deque_start (deque_t deque, const void *src);

size_t remove_from_deque_start (deque_t deque, void *dst, size_t len);
size_t remove_from_deque_end (deque_t deque, void *dst, size_t len);
bool single_remove_from_deque_start (deque_t deque, void *dst);
bool single_remove_from_deque_end (deque_t deque, void *dst);

void clear_deque (deque_t);

#endif
