/* $Id: filestore_common.h 733 2006-06-12 23:10:00Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <stdlib.h>
#include <inttypes.h>
#include "path.h"

#ifndef FILESTORE_COMMON_H
#define FILESTORE_COMMON_H

typedef uint64_t filestore_id_t;

#define GZIP_FILTER_FLAG   'g'
#define BZIP2_FILTER_FLAG  'b'
#define GPG_FILTER_FLAG    'G'

/* Max length of acceptable tags.  Setting this to something reasonably short
 * makes it easier to detect when the luser asked us to process something which
 * is not a teebu archive. */
#define MAX_TAG_LEN 16

/* Number of bytes in an archive ID. */
#define ID_LEN 8

/* These are the file permissions we currently save */
#define SAVE_PERMS (S_IRWXU | S_IRWXG | S_IRWXO)

// Flags for filetypes.
static const char
  regfiletype = 'F', softlinkfiletype = 'S', dirfiletype = 'D';

// If you update this enum, you MUST update the TAGS array in
// filestore_common.c!  Failing to do this will bring DOOM!
typedef enum tags
{
  TEEBU_FILESTORE_TAG,
  ARCHIVE_TIMESTAMP_TAG,
  ARCHIVE_ID_TAG,
  ARCHIVE_LABEL_TAG,
  CHUNK_FILTER_TAG,
  CHECKSUM_HINT_TAG,
  FILETYPE_TAG,
  PATH_TAG,
  LINK_TAG,
  FILEDATA_TAG,
  UNIX_PERM_TAG,
  CREATION_TIME_TAG,
  MODIFICATION_TIME_TAG,
  FILE_OWNER_TAG,
  FILE_GROUP_TAG,
  MD5SUM_TAG,
  SHA1SUM_TAG,
  UNKNOWN_TAG                   // Place last
} tag_t;

extern const char *TAGS[];
extern size_t *TAG_LENS;

#define TAG_TEXT(tag) TAGS[tag]

#define TAG_LEN(tag) (NULL != TAG_LENS ? TAG_LENS[tag] : init_tag_len(tag))

#define TIME_FORMAT "%04d%02d%02d %02d%02d%02d"
#define FORMATTED_TIME_DATA_SIZE 15
#define FORMATTED_TIME_BUFFER_SIZE (FORMATTED_TIME_DATA_SIZE+1)

#define PRETTY_TIME_FORMAT "%04d-%02d-%02d %02d:%02d:%02d"
#define PRETTY_FORMATTED_TIME_DATA_SIZE 19
#define PRETTY_FORMATTED_TIME_BUFFER_SIZE (PRETTY_FORMATTED_TIME_DATA_SIZE+1)

/* Init TAG_LENS array, and lookup the size of the given tag.  */
size_t init_tag_len (tag_t tag);

/* Lookup a tag_t based on the given string.  Returns UNKNOWN_TAG is no tag
 * matches. */
tag_t lookup_tag (const char *tag_text);

/* Format a file modification time into the given buffer, which must be at
 * least FORMATTED_TIME_BUFFER_SIZE characters long, or
 * PRETTY_TIME_FORMMATED_BUFER_SIZE if pretty is true.  If pretty is true,
 * format for display. */
bool format_time(time_t t, char *buf, bool pretty);

/* Parse a modification time from the given buffer */
bool parse_time(char *buf, time_t *result);

/* Read where a link points to.  The caller must free() the returned buffer. */
char * read_link (path_t path);

#endif
