/* $Id: terminatedint.h 619 2006-05-10 12:52:05Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef LIST_H
#define LIST_H

#include <stdbool.h>
#include <stdlib.h>

typedef struct list *list_t;
typedef struct iterator *iterator_t;

typedef size_t (*next_size_f) (void *, size_t);

list_t empty_list ();
void release_list (list_t);

void list_cons (void *, list_t);
void list_snoc (list_t, void *);

bool is_empty_list (list_t);
size_t list_length (list_t list);

void *list_head (list_t);
void *list_last (list_t);

void *list_head (list_t);
void *remove_list_head (list_t);
void *remove_list_last (list_t);

void clear_list (list_t);
list_t copy_list (list_t);

/* Append all items from right list onto end of left list. */
void list_append_l (list_t, list_t);

/* Append all items from left list onto start of right list. */
void list_append_r (list_t, list_t);

/* Return an iterator */
iterator_t list_iterator (list_t);

/* True iff iterator has another element. */
bool iterator_has_next (iterator_t);

/* Advance to next element, and return. */
void *iterator_next (iterator_t);

/* Remove last element returned by iterator_next(). */
void *iterator_remove (iterator_t);

/* Release an iterator. */
void release_iterator (iterator_t);

#endif
