/* $Id: md5sumio.h 659 2006-05-13 14:51:08Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * Input and output streams which compute checksum using md5sum.  A buffer is
 * supplied when opening the stream.  When the stream is closed, this buffer
 * will be filled with the checksum computed by the program.
 */

#ifndef MD5SUMIO_H
#define MD5SUMIO_H

#include "nonstdio.h"

// 32 +1 for terminator
#define MD5_SUM_LEN 33

out_stream_t md5sumio_open_out (out_stream_t, bool own_base, char *buffer);
in_stream_t md5sumio_open_in (in_stream_t, bool own_base, char *buffer);

#endif
