/* $Id: nullio.c 658 2006-05-13 14:50:30Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include "nullio.h"

static output_err_t
nullio_output_limited (void *data, iobuffer_t * buf, size_t max)
{
  size_t size = iobuffer_data_size (buf);
  if (max < size)
    size = max;

  iobuffer_mark_taken (buf, size);
  return OUTPUT_OK;
}

static out_stream_type_t nullio_out_type = {
  .output_limited = nullio_output_limited,
  .output_mark = NULL,          // Unsupported
  .flush = NULL,                // Uneeded
  .close_out = NULL,            // Uneeded
  .release_out = NULL           // Uneeded
};

out_stream_t
nullio_open_out ()
{
  return open_out (&nullio_out_type, NULL);
}
