/* $Id: stringio.h 659 2006-05-13 14:51:08Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

/*
 * Streams that write to and read from strings.
 */

#ifndef STRINGIO_H
#define STRINGIO_H

#include "nonstdio.h"

/* An output stream which writes to a string.
 * If discard_excess is true, any bytes written after the buffer is filled will
 * be discarded.  Otherwise, an OUTPUT_ERR_REFUSED error will occur.
 * If own_buf is true, the buffer will be free()d when the out_stream is
 * released.
 */
out_stream_t stringio_open_out (char *buf, size_t buf_len, size_t * out_count,
                                bool discard_excess, bool own_buf);

/* An input stream which reads from string.  */
in_stream_t stringio_open_in (char *buf, size_t buf_len, bool own_buf);

#endif
