/* $Id: terminatedint.c 658 2006-05-13 14:50:30Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <assert.h>

#include "terminatedint.h"

#define LOW_BITS 0x7F
#define HIGH_BIT 0x80

bool
encode_uint32_byte (char *dst, uint32_t * x)
{
  *dst = (char) (LOW_BITS & *x);
  *x >>= 7;

  if (0 != *x)
    *dst |= HIGH_BIT;

  return 0 != *x;
}

size_t
encode_uint32 (char *dst, uint32_t x)
{
  size_t n = 0;
  while (encode_uint32_byte (dst + n, &x))
    n++;
  return n + 1;
}

bool
encode_uint64_byte (char *dst, uint64_t * x)
{
  *dst = (char) (LOW_BITS & *x);
  *x >>= 7;

  if (0 != *x)
    *dst |= HIGH_BIT;

  return 0 != *x;
}

size_t
encode_uint64 (char *dst, uint64_t x)
{
  size_t n = 0;
  while (encode_uint64_byte (dst + n, &x))
    n++;
  return n + 1;
}

bool
decode_uint32_byte (uint32_t * a, int pos, const char *src)
{
  assert (pos < UINT32_MAX_BYTES);

  *a |= ((uint32_t) (LOW_BITS & *src) << (pos * 7));
  return 0 != (HIGH_BIT & *src);
}


bool
decode_uint32 (const char *src, size_t len, uint32_t * result)
{
  *result = 0;
  for (int pos = 0; pos < len; pos++)
    if (!decode_uint32_byte (result, pos, src + pos))
      return true;

  return false;
}

bool
decode_uint64_byte (uint64_t * a, int pos, const char *src)
{
  assert (pos < UINT64_MAX_BYTES);

  *a |= ((uint64_t) (LOW_BITS & *src) << (pos * 7));
  return 0 != (HIGH_BIT & *src);
}
