/* $Id: uidcache.h 703 2006-05-24 22:27:04Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/


/*
 * Create a cache of uid->username and username->uid mappings, to avoid
 * repeatedly reading /etc/passwd
 */

#ifndef UIDCACHE_H
#define UIDCACHE_H

#include <sys/types.h>
#include <stdbool.h>

typedef struct uidcache *uidcache_t;

/* Create a cache */
uidcache_t create_uidcache (void);

/* Release a cache. */
void release_uidcache (uidcache_t);

/* Return the username associated with a uid or NULL iff not found. */
const char *lookup_username_from_uid (uidcache_t, uid_t);

/* Return the uid associated with a username.  Places result in *result and
 * returns true iff sucessful. */
bool lookup_uid_from_username (uidcache_t, const char *, uid_t *result);

/* Return the groupname associated with a gid or NULL iff not found. */
const char *lookup_groupname_from_gid (uidcache_t, gid_t);

/* Return the gid associated with a groupname */
bool lookup_gid_from_groupname (uidcache_t, const char *, gid_t *result);

#endif

