/* $Id: check_commandprocess.c 659 2006-05-13 14:51:08Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include "check_io.h"
#include "check_commandprocess.h"

#include "deque.h"
#include "commandprocess.h"

static int
test_size ()
{
  switch (get_test_size ())
    {
    case QUICK_TEST:
      return 256;
    case NORMAL_TEST:
      return 1024;
    case LONG_TEST:
      return 1024 * 1024;
    default:
      fail ("Invalid test size");
      return -1;                // Not reached, prevent compiler warning
    }
}

void
buffer_consumer (void *uncast_deque, const char *buf, size_t size)
{
  deque_t deque = (deque_t) uncast_deque;
  assert (deque);

  add_to_deque_end (deque, buf, size);
}

START_TEST (check_cat)
{
  char *argv[] = { (char *) NULL };

  char *env[] = { (char *) NULL };

  deque_t out = create_deque (sizeof (char), 32);
  comproc_t test_cp =
    create_comproc (buffer_consumer, out, DEFAULT_COMPROC_BUFFER, "/bin/cat",
                    argv, env, NULL, NULL);
  fail_if (!test_cp);

  // Write some data, and check we get same data out.
  const size_t write_size = 16;
  const size_t write_count = test_size ();
  char buf[write_size];
  for (int i = 0; i < write_size; i++)
    buf[i] = i;

  // Write
  for (int i = 0; i < write_count; i++)
    send_to_comproc (test_cp, buf, write_size);

  finish_comproc_input (test_cp);

  // Check
  for (int i = 0; i < write_count; i++)
    {
      for (int j = 0; j < write_size; j++)
        buf[j] = -1;

      fail_unless (write_size ==
                   remove_from_deque_start (out, buf, write_size));
      for (int j = 0; j < write_size; j++)
        {
          if ((char) j != buf[j])
            {
              char msgbuf[256];
              snprintf (msgbuf, 256, "Expected %d but got %d (i = %d)",
                        (char) j, buf[write_size], i);
              fail (msgbuf);
            }
        }
    }

  release_comproc (test_cp);
}
END_TEST void
add_commandprocess_tests (Suite * s)
{
  TCase *tc_core = tcase_create ("CommandProcess");
  tcase_add_test (tc_core, check_cat);

  suite_add_tcase (s, tc_core);
}
