/* $Id: check_debugio.c 659 2006-05-13 14:51:08Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <stdbool.h>
#include <assert.h>

#include  "baseio.h"
#include  "selfsyncio.h"
#include  "debugio.h"

#include  "check_io.h"
#include  "check_debugio.h"

#define TEST_FILE "/tmp/bumtest.debugio.tmp"

/* We just stole the selfsyncio tests.  */

static const char short_escape[] = "B";
static const int short_escape_len = 1;

static const char medium_escape[] = "BC";
static const int medium_escape_len = 2;

static const char long_escape[] = "BCDEFGHIJK";
static const int long_escape_len = 10;

START_TEST (check_out_basic)
{
  out_stream_t outs = baseio_open_out (TEST_FILE, "w");
  fail_if (!outs);

  outs =
    selfsync_open_out (medium_escape_len, medium_escape, outs, false, false);
  fail_if (!outs);

  outs = debugio_open_out (outs, "TestO", 16, true, 0, DEBUGIO_MAX_LEN, true);

  basic_out_test (outs);
  release_out (outs);
}
END_TEST static int
read_write_test_size ()
{
  switch (get_test_size ())
    {
    case QUICK_TEST:
      return 256;
    case NORMAL_TEST:
      return 1024;
    case LONG_TEST:
      return 1024 * 1024;
    default:
      fail ("Invalid test size");
      return -1;                // Not reached, prevent compiler warning
    }
}

static void
check_read_write (bool with_marks, int escape_len, const char *escape,
                  int block_size)
{
  const int
    test_size = read_write_test_size (), count = test_size / block_size;

  assert (count > 0);
  assert (test_size > 0);

  out_stream_t outs = baseio_open_out (TEST_FILE, "w");
  fail_if (!outs);
  outs = selfsync_open_out (escape_len, escape, outs, false, true);
  fail_if (!outs);
  outs = debugio_open_out (outs, "TestO", 16, true, 0, DEBUGIO_MAX_LEN, true);
  fail_if (!outs);

  ascending_output_half_test (with_marks, outs, block_size, count);
  release_out (outs);

  mark_point ();

  in_stream_t ins = baseio_open_in (TEST_FILE, "r");
  fail_if (!ins);
  ins = selfsync_open_in (escape_len, escape, 4096, ins, false, true);
  fail_if (!ins);
  ins = debugio_open_in (ins, "TestI", 16, true, 9, DEBUGIO_MAX_LEN, true);
  ascending_input_half_test (true, with_marks, ins, block_size, count);
  release_in (ins);
}

/** If only C had closures.  Then we wouldn't have to define this repetetive
 * test in a macro. */

#define MAKE_READ_WRITE_CHECK(name, escape_len, escape, marks, block_len) \
START_TEST (name) \
{ \
  check_read_write(marks, escape_len, escape, block_len) ; \
} \
END_TEST

MAKE_READ_WRITE_CHECK (check_read_write_s_s, short_escape_len, short_escape,
                       false,
                       1) MAKE_READ_WRITE_CHECK (check_read_write_s_s_m,
                                                 short_escape_len,
                                                 short_escape, true,
                                                 1)
MAKE_READ_WRITE_CHECK (check_read_write_s_m, short_escape_len, short_escape,
                       false,
                       32) MAKE_READ_WRITE_CHECK (check_read_write_s_m_m,
                                                  short_escape_len,
                                                  short_escape, true,
                                                  32)
MAKE_READ_WRITE_CHECK (check_read_write_s_l, short_escape_len, short_escape,
                       false,
                       256) MAKE_READ_WRITE_CHECK (check_read_write_s_l_m,
                                                   short_escape_len,
                                                   short_escape, true,
                                                   256)
MAKE_READ_WRITE_CHECK (check_read_write_m_s, medium_escape_len, medium_escape,
                       false,
                       1) MAKE_READ_WRITE_CHECK (check_read_write_m_s_m,
                                                 medium_escape_len,
                                                 medium_escape, true,
                                                 1)
MAKE_READ_WRITE_CHECK (check_read_write_m_m, medium_escape_len, medium_escape,
                       false,
                       32) MAKE_READ_WRITE_CHECK (check_read_write_m_m_m,
                                                  medium_escape_len,
                                                  medium_escape, true,
                                                  32)
MAKE_READ_WRITE_CHECK (check_read_write_m_l, medium_escape_len, medium_escape,
                       false,
                       256) MAKE_READ_WRITE_CHECK (check_read_write_m_l_m,
                                                   medium_escape_len,
                                                   medium_escape, true,
                                                   256)
MAKE_READ_WRITE_CHECK (check_read_write_l_s, long_escape_len, long_escape,
                       false,
                       1) MAKE_READ_WRITE_CHECK (check_read_write_l_s_m,
                                                 long_escape_len, long_escape,
                                                 true,
                                                 1)
MAKE_READ_WRITE_CHECK (check_read_write_l_m, long_escape_len, long_escape,
                       false,
                       32) MAKE_READ_WRITE_CHECK (check_read_write_l_m_m,
                                                  long_escape_len,
                                                  long_escape, true,
                                                  32)
MAKE_READ_WRITE_CHECK (check_read_write_l_l, long_escape_len, long_escape,
                       false,
                       256) MAKE_READ_WRITE_CHECK (check_read_write_l_l_m,
                                                   long_escape_len,
                                                   long_escape, true, 256)
     void
     add_debugio_tests (Suite * s)
{
  TCase *tc_core = tcase_create ("DebugIO");
  tcase_add_test (tc_core, check_out_basic);
  tcase_add_test (tc_core, check_read_write_s_s);
  tcase_add_test (tc_core, check_read_write_s_s_m);
  tcase_add_test (tc_core, check_read_write_s_m);
  tcase_add_test (tc_core, check_read_write_s_m_m);
  tcase_add_test (tc_core, check_read_write_s_l);
  tcase_add_test (tc_core, check_read_write_s_l_m);
  tcase_add_test (tc_core, check_read_write_m_s);
  tcase_add_test (tc_core, check_read_write_m_s_m);
  tcase_add_test (tc_core, check_read_write_m_m);
  tcase_add_test (tc_core, check_read_write_m_m_m);
  tcase_add_test (tc_core, check_read_write_m_l);
  tcase_add_test (tc_core, check_read_write_m_l_m);
  tcase_add_test (tc_core, check_read_write_l_s);
  tcase_add_test (tc_core, check_read_write_l_s_m);
  tcase_add_test (tc_core, check_read_write_l_m);
  tcase_add_test (tc_core, check_read_write_l_m_m);
  tcase_add_test (tc_core, check_read_write_l_l);
  tcase_add_test (tc_core, check_read_write_l_l_m);

  suite_add_tcase (s, tc_core);
}
