/* $Id: check_filestore.c 711 2006-05-29 17:49:41Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include "filestore.h"
#include "baseio.h"
#include "check_filestore.h"

#define TEST_FILE "/tmp/bumtest.filestore.tmp"

START_TEST (check_basic)
{
  {
    out_stream_t base_outs = baseio_open_out (TEST_FILE, "w");
    fail_if (NULL == base_outs);
    filestore_out_params_t params;
    init_filestore_out_params(&params, base_outs);
    filestore_out_t fso = open_filestore_out (&params);
    path_t path = make_path ("/bin/bash");
    fail_unless (filestore_output_file (fso, path, NULL));
    path_add (path, "/usr/bin/ld");
    fail_unless (filestore_output_file (fso, path, NULL));
    release_path (path);
    fail_unless (close_filestore_out (fso));
    release_filestore_out (fso);
    // fail_unless (OUTPUT_OK == close_out (base_outs));
    //release_out (base_outs);
  }
  mark_point ();
  {
    in_stream_t base_ins = baseio_open_in (TEST_FILE, "r");
    fail_if (NULL == base_ins);
    filestore_in_params_t params;
    init_filestore_in_params (&params, base_ins);
    filestore_in_t fsi =
      open_filestore_in (&params);

    filestore_stats_t stats;
    init_filestore_stats (&stats);
    path_t root = root_path ();
    fail_unless (filestore_verify_in (fsi, &stats, root, NULL, NULL));
    release_path (root);

    fail_unless (close_filestore_in (fsi));
    release_filestore_in (fsi);
  }
}
END_TEST

void
add_filestore_tests (Suite * s)
{
  TCase *tc_core = tcase_create ("FileStore");
  tcase_add_test (tc_core, check_basic);
  suite_add_tcase (s, tc_core);
}
