/* $Id: check_infpipeio.c 659 2006-05-13 14:51:08Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>

#include "infpipeio.h"
#include "check_io.h"
#include "check_infpipeio.h"

/* Tests stolen from baseio. */

#define TEST_FILE "/tmp/bumtest.infpipeio.tmp"

static int
read_write_test_size ()
{
  switch (get_test_size ())
    {
    case QUICK_TEST:
      return 256;
    case NORMAL_TEST:
      return 1024;
    case LONG_TEST:
      return 10240;
    default:
      fail ("Invalid test size");
      return -1;                // Not reached, prevent compiler warning
    }
}

START_TEST (check_out_basic)
{
  out_stream_t outs;
  in_stream_t ins;
  fail_unless (infpipe_open (&outs, &ins, NULL));
  basic_out_test (outs);
  release_out (outs);
  close_and_release_in (ins);
}
END_TEST static void
check_read_write (int block_size)
{
  const int
    test_size = read_write_test_size (), count = test_size / block_size;

  assert (count > 0);
  assert (test_size > 0);

  out_stream_t outs;
  in_stream_t ins;
  fail_unless (infpipe_open (&outs, &ins, NULL));
  ascending_output_half_test (false, outs, block_size, count);
  release_out (outs);

  mark_point ();

  ascending_input_half_test (true, false, ins, block_size, count);
  release_in (ins);
}

START_TEST (check_read_write_small_blocks)
{
  check_read_write (1);
}

END_TEST
START_TEST (check_read_write_medium_blocks)
{
  check_read_write (32);
}

END_TEST
START_TEST (check_read_write_large_blocks)
{
  check_read_write (256);
}
END_TEST void
add_infpipeio_tests (Suite * s)
{
  TCase *tc_core = tcase_create ("InfPipeIO");
  tcase_add_test (tc_core, check_out_basic);
  tcase_add_test (tc_core, check_read_write_small_blocks);
  tcase_add_test (tc_core, check_read_write_medium_blocks);
  tcase_add_test (tc_core, check_read_write_large_blocks);

  suite_add_tcase (s, tc_core);
}
