/* $Id: check_io.h 659 2006-05-13 14:51:08Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#ifndef CHECK_IO_H
#define CHECK_IO_H

#include "nonstdio.h"

enum
{ QUICK_TEST, NORMAL_TEST, LONG_TEST };

typedef int test_size_t;

test_size_t get_test_size ();
void set_test_size (test_size_t);

void basic_out_test (out_stream_t);

void ascending_output_half_test (bool write_marks, out_stream_t,
                                 const int data_size, const int repeats);
void ascending_input_half_test (bool check_eof, bool read_marks, in_stream_t,
                                const int data_size, const int repeats);

#define MSG_BUF_SIZE 256

#define fail_unless_out_status(expected, butgot) \
  { output_err_t r = butgot ; \
    if(expected != r) { \
    char buf[MSG_BUF_SIZE] ; \
    snprintf(buf, MSG_BUF_SIZE, "Expected %s but got %s", \
        OUTPUT_ERR_NAME(expected), OUTPUT_ERR_NAME(r)) ; \
    fail(buf) ; \
  } \
}

#define fail_unless_in_status(expected, butgot) \
  { input_err_t r = butgot ; \
    if(expected != r) { \
    char buf[MSG_BUF_SIZE] ; \
    snprintf(buf, MSG_BUF_SIZE, "Expected %s but got %s", \
        INPUT_ERR_NAME(expected), INPUT_ERR_NAME(r)) ; \
    fail(buf) ; \
  } \
}

#endif
