/* $Id: check_stringio.c 659 2006-05-13 14:51:08Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <assert.h>

#include "stringio.h"

#include "check_io.h"
#include "check_stringio.h"

#define TEST_FILE "/tmp/bumtest.stringio.tmp"

static int
read_write_test_size ()
{
  switch (get_test_size ())
    {
    case QUICK_TEST:
      return 256;
    case NORMAL_TEST:
      return 1024;
    case LONG_TEST:
      return 10240;
    default:
      fail ("Invalid test size");
      return -1;                // Not reached, prevent compiler warning
    }
}

#define BUFFER_SIZE (1024*1024)

static void
check_read_write (int block_size)
{
  const int
    test_size = read_write_test_size (), count = test_size / block_size;

  char *buffer = malloc (BUFFER_SIZE);
  fail_if (!buffer);

  assert (count > 0);
  assert (test_size > 0);

  size_t out_count = 0;
  out_stream_t outs =
    stringio_open_out (buffer, BUFFER_SIZE, &out_count, false, false);
  fail_if (!outs);

  ascending_output_half_test (false, outs, block_size, count);
  release_out (outs);

  mark_point ();

  in_stream_t ins = stringio_open_in (buffer, out_count, false);
  fail_if (!ins);

  ascending_input_half_test (true, false, ins, block_size, count);
  release_in (ins);
}

START_TEST (check_read_write_small_blocks)
{
  check_read_write (1);
}

END_TEST
START_TEST (check_read_write_medium_blocks)
{
  check_read_write (32);
}

END_TEST
START_TEST (check_read_write_large_blocks)
{
  check_read_write (256);
}
END_TEST void
add_stringio_tests (Suite * s)
{
  TCase *tc_core = tcase_create ("StringIO");
  tcase_add_test (tc_core, check_read_write_small_blocks);
  tcase_add_test (tc_core, check_read_write_medium_blocks);
  tcase_add_test (tc_core, check_read_write_large_blocks);

  suite_add_tcase (s, tc_core);
}
