<?xml version="1.0"?>
<!--
    text-nodes.mod.xsl - XSLT routines for processing text nodes.
	$Id: text-nodes.mod.xsl,v 1.13 2005/04/02 09:40:37 Bronger Exp $	

    Copyright © 2004, 2005 Torsten Bronger <bronger@physik.rwth-aachen.de>.

    This file is part of texi2latex.

    texi2latex is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License as published by the Free
    Software Foundation; either version 2 of the License, or (at your option)
    any later version.

    texi2latex is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with texi2latex; if not, write to the Free Software Foundation, Inc., 59
    Temple Place, Suite 330, Boston, MA 02111-1307 USA
-->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- These delimiters come from the tbook system.  (tbook has even more, but up
     to now they wouldn't make sense in texi2latex.)  They are inserted into
     the output and used (and removed) by tbrplent.  tbrplent can identify text
     nodes and distiguish them from LaTeX code.  Otherwise a word that you want
     to have in bold face ends up as "\textbf{foo}" (sic!) on the paper. -->

<xsl:variable name="start-delimiter" select="'&#x98;'"/>
<xsl:variable name="end-delimiter" select="'&#x9c;'"/>

<xsl:template match="text()" name="process-text" priority="0">
  <xsl:value-of select="$start-delimiter"/>
  <xsl:value-of select="."/>
  <xsl:value-of select="$end-delimiter"/>
</xsl:template>

<!-- In verbatim environments we do the same as above, *plus* an \xobeyspaces
     Notice that @verbatim itself needs special treatment, so it's not listed
     here.  -->

<xsl:template match="text()[ancestor::example or ancestor::smallexample or
                     ancestor::display or ancestor::smalldisplay or
                     ancestor::format or ancestor::smallformat]"
                     priority="0.1">
  <xsl:text>{\xobeyspaces{}</xsl:text>
  <xsl:call-template name="process-text"/>
  <xsl:text>}</xsl:text>
</xsl:template>

<xsl:template match="linebreak">
  <xsl:text>\\\relax </xsl:text>
</xsl:template>

<!-- This is a weak point of Texinfo's XML format: Punctuation with explicit
     information about whether it is the end of a sentence or not, is only
     inserted where TeX's heuristic would fail.  Since I convert to LaTeX, it
     doesn't matter to me, on the contrary, it makes it very simple for me.
     However, for the *general* XML format this is unfortunate (although not
     unacceptable). -->

<xsl:template match="punct">
  <xsl:if test="@end-of-sentence = 'yes'">
    <xsl:text>\@</xsl:text>
  </xsl:if>
  <xsl:apply-templates/>
  <xsl:if test="@end-of-sentence = 'no'">
    <xsl:text>\@{}</xsl:text>
  </xsl:if>
</xsl:template>

</xsl:stylesheet>
